/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutablePassengerData;
import org.spongepowered.api.data.manipulator.mutable.entity.PassengerData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableListValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.World;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongePassengerData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class PassengerDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, List<UUID>, ListValue<UUID>, PassengerData, ImmutablePassengerData> {
    public PassengerDataProcessor() {
        super(Entity.class, Keys.PASSENGERS);
    }

    @Override
    protected boolean set(Entity entity, List<UUID> uuids) {
        List passengers = uuids.stream().map(uuid -> ((World)entity.func_130014_f_()).getEntity((UUID)uuid)).filter(Optional::isPresent).map(Optional::get).map(tickingEntity -> (Entity)tickingEntity).collect(Collectors.toList());
        for (Entity passenger : passengers) {
            if (entity.func_184196_w(passenger)) continue;
            entity.func_184188_bt().add(passenger);
        }
        return true;
    }

    @Override
    protected Optional<List<UUID>> getVal(Entity dataHolder) {
        if (dataHolder.func_184188_bt().isEmpty()) {
            return Optional.empty();
        }
        List passengers = dataHolder.func_184188_bt().stream().map(entity -> (org.spongepowered.api.entity.Entity)entity).map(Identifiable::getUniqueId).collect(Collectors.toList());
        return Optional.of(passengers);
    }

    @Override
    protected ImmutableListValue<UUID> constructImmutableValue(List<UUID> value) {
        return new ImmutableSpongeListValue<UUID>(Keys.PASSENGERS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<UUID> constructValue(List<UUID> actualValue) {
        return new SpongeListValue<UUID>(Keys.PASSENGERS, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            Entity entity = (Entity)container;
            if (entity.func_184188_bt().isEmpty()) {
                ImmutableList<UUID> passengers = entity.func_184188_bt().stream().map(entity1 -> (org.spongepowered.api.entity.Entity)entity1).map(Identifiable::getUniqueId).collect(ImmutableList.toImmutableList());
                entity.func_184226_ay();
                return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).replace(this.constructImmutableValue((List<UUID>)passengers)).build();
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public Optional<PassengerData> fill(DataContainer container, PassengerData passengerData) {
        passengerData.set(Keys.PASSENGERS, container.getObjectList(Keys.PASSENGERS.getQuery(), UUID.class).get());
        return Optional.of(passengerData);
    }

    @Override
    protected PassengerData createManipulator() {
        return new SpongePassengerData();
    }
}

