/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableTradeOfferData;
import org.spongepowered.api.data.manipulator.mutable.entity.TradeOfferData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.common.data.manipulator.mutable.SpongeTradeOfferData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.mixin.core.entity.passive.EntityVillagerAccessor;

public class TradeOfferDataProcessor
extends AbstractEntitySingleDataProcessor<EntityVillager, List<TradeOffer>, ListValue<TradeOffer>, TradeOfferData, ImmutableTradeOfferData> {
    public TradeOfferDataProcessor() {
        super(EntityVillager.class, Keys.TRADE_OFFERS);
    }

    private static List<TradeOffer> toTradeOfferList(MerchantRecipeList list) {
        ArrayList<TradeOffer> offers = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            offers.add((TradeOffer)list.get(i));
        }
        return offers;
    }

    private static MerchantRecipeList toMerchantRecipeList(List<TradeOffer> offers) {
        MerchantRecipeList list = new MerchantRecipeList();
        for (TradeOffer offer : offers) {
            list.add((Object)((MerchantRecipe)offer));
        }
        return list;
    }

    @Override
    protected ListValue<TradeOffer> constructValue(List<TradeOffer> actualValue) {
        return SpongeValueFactory.getInstance().createListValue(Keys.TRADE_OFFERS, actualValue);
    }

    @Override
    protected boolean set(EntityVillager entity, List<TradeOffer> value) {
        ((EntityVillagerAccessor)entity).accessor$setBuyingList(TradeOfferDataProcessor.toMerchantRecipeList(value));
        return true;
    }

    @Override
    protected Optional<List<TradeOffer>> getVal(EntityVillager entity) {
        MerchantRecipeList recipes = ((EntityVillagerAccessor)entity).accessor$getBuyingList();
        if (recipes == null) {
            ((EntityVillagerAccessor)entity).accessor$PopulateBuyingList();
        }
        return Optional.of(TradeOfferDataProcessor.toTradeOfferList(((EntityVillagerAccessor)entity).accessor$getBuyingList()));
    }

    @Override
    protected ImmutableValue<List<TradeOffer>> constructImmutableValue(List<TradeOffer> value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected TradeOfferData createManipulator() {
        return new SpongeTradeOfferData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

