/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

abstract class AbstractItemBookPagesProcessor<T, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractItemSingleDataProcessor<List<T>, ListValue<T>, M, I> {
    AbstractItemBookPagesProcessor(Predicate<ItemStack> predicate, Key<ListValue<T>> key) {
        super(predicate, key);
    }

    abstract NBTTagString translateTo(T var1);

    abstract T translateFrom(String var1);

    @Override
    public Optional<M> fill(DataContainer container, M pagedData) {
        List pages = DataUtil.getData((DataView)container, this.key, List.class).stream().map(this::translateFrom).collect(Collectors.toList());
        return Optional.of(pagedData.set(this.key, pages));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            Optional<List<T>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                tag.func_74782_a("pages", (NBTBase)new NBTTagList());
            }
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(ItemStack itemStack, List<T> value) {
        NBTTagList list = new NBTTagList();
        for (T page : value) {
            list.func_74742_a((NBTBase)this.translateTo(page));
        }
        itemStack.func_77983_a("pages", (NBTBase)list);
        NBTTagCompound compound = itemStack.func_77978_p();
        if (!compound.func_74764_b("title")) {
            compound.func_74778_a("title", "invalid");
        }
        if (!compound.func_74764_b("author")) {
            compound.func_74778_a("author", "invalid");
        }
        compound.func_74757_a("resolved", true);
        return true;
    }

    @Override
    protected Optional<List<T>> getVal(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("pages")) {
            return Optional.empty();
        }
        NBTTagList list = tagCompound.func_150295_c("pages", 8);
        ArrayList<T> stringList = new ArrayList<T>();
        if (!list.func_82582_d()) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                stringList.add(this.translateFrom(list.func_150307_f(i)));
            }
        }
        return Optional.of(stringList);
    }

    @Override
    protected ListValue<T> constructValue(List<T> actualValue) {
        return new SpongeListValue<T>(this.key, actualValue);
    }

    @Override
    protected ImmutableValue<List<T>> constructImmutableValue(List<T> value) {
        return new ImmutableSpongeListValue<T>(this.key, ImmutableList.copyOf(value));
    }
}

