/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableEnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeEnchantmentData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.util.Constants;

public class ItemEnchantmentDataProcessor
extends AbstractItemSingleDataProcessor<List<org.spongepowered.api.item.enchantment.Enchantment>, ListValue<org.spongepowered.api.item.enchantment.Enchantment>, EnchantmentData, ImmutableEnchantmentData> {
    public ItemEnchantmentDataProcessor() {
        super((ItemStack input) -> true, Keys.ITEM_ENCHANTMENTS);
    }

    @Override
    protected EnchantmentData createManipulator() {
        return new SpongeEnchantmentData();
    }

    @Override
    protected boolean set(ItemStack itemStack, List<org.spongepowered.api.item.enchantment.Enchantment> value) {
        NBTTagCompound compound;
        if (itemStack.func_77978_p() == null) {
            compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
        } else {
            compound = itemStack.func_77978_p();
        }
        if (value.isEmpty()) {
            compound.func_82580_o("ench");
        } else {
            LinkedHashMap<EnchantmentType, Integer> valueMap = Maps.newLinkedHashMap();
            for (org.spongepowered.api.item.enchantment.Enchantment enchantment : value) {
                valueMap.put(enchantment.getType(), enchantment.getLevel());
            }
            NBTTagList newList = new NBTTagList();
            for (Map.Entry entry : valueMap.entrySet()) {
                NBTTagCompound enchantmentCompound = new NBTTagCompound();
                enchantmentCompound.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)((Enchantment)entry.getKey())));
                enchantmentCompound.func_74777_a("lvl", ((Integer)entry.getValue()).shortValue());
                newList.func_74742_a((NBTBase)enchantmentCompound);
            }
            compound.func_74782_a("ench", (NBTBase)newList);
        }
        return true;
    }

    @Override
    protected Optional<List<org.spongepowered.api.item.enchantment.Enchantment>> getVal(ItemStack itemStack) {
        if (itemStack.func_77948_v()) {
            return Optional.of(Constants.NBT.getItemEnchantments(itemStack));
        }
        return Optional.empty();
    }

    @Override
    protected ListValue<org.spongepowered.api.item.enchantment.Enchantment> constructValue(List<org.spongepowered.api.item.enchantment.Enchantment> actualValue) {
        return new SpongeListValue<org.spongepowered.api.item.enchantment.Enchantment>(Keys.ITEM_ENCHANTMENTS, actualValue);
    }

    @Override
    protected ImmutableValue<List<org.spongepowered.api.item.enchantment.Enchantment>> constructImmutableValue(List<org.spongepowered.api.item.enchantment.Enchantment> value) {
        return new ImmutableSpongeListValue<org.spongepowered.api.item.enchantment.Enchantment>(Keys.ITEM_ENCHANTMENTS, ImmutableList.copyOf(value));
    }

    @Override
    public Optional<EnchantmentData> fill(DataContainer container, EnchantmentData enchantmentData) {
        DataUtil.checkDataExists(container, Keys.ITEM_ENCHANTMENTS.getQuery());
        List<org.spongepowered.api.item.enchantment.Enchantment> enchantments = container.getSerializableList(Keys.ITEM_ENCHANTMENTS.getQuery(), org.spongepowered.api.item.enchantment.Enchantment.class).get();
        ListValue<org.spongepowered.api.item.enchantment.Enchantment> existing = enchantmentData.enchantments();
        existing.addAll(enchantments);
        enchantmentData.set((BaseValue<?>)existing);
        return Optional.of(enchantmentData);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ItemStack) {
            ItemStack stack = (ItemStack)container;
            Optional<List<org.spongepowered.api.item.enchantment.Enchantment>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            stack.func_77978_p().func_82580_o("ench");
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }
}

