/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableSignData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeSignData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.text.SpongeTexts;

public class ItemSignDataProcessor
extends AbstractItemSingleDataProcessor<List<Text>, ListValue<Text>, SignData, ImmutableSignData> {
    public ItemSignDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b().equals(Items.field_151155_ap), Keys.SIGN_LINES);
    }

    @Override
    protected Optional<List<Text>> getVal(ItemStack itemStack) {
        NBTTagCompound mainCompound = itemStack.func_77978_p();
        if (mainCompound == null) {
            return Optional.empty();
        }
        if (!mainCompound.func_150297_b("BlockEntityTag", 10) || !mainCompound.func_74775_l("BlockEntityTag").func_74764_b("id")) {
            return Optional.empty();
        }
        NBTTagCompound tileCompound = mainCompound.func_74775_l("BlockEntityTag");
        String id = tileCompound.func_74779_i("id");
        if (!id.equalsIgnoreCase("Sign")) {
            return Optional.empty();
        }
        ArrayList<Text> texts = Lists.newArrayListWithCapacity(4);
        for (int i = 0; i < 4; ++i) {
            texts.add(SpongeTexts.fromLegacy(tileCompound.func_74779_i("Text" + (i + 1))));
        }
        return Optional.of(texts);
    }

    @Override
    public Optional<SignData> fill(DataContainer container, SignData signData) {
        ArrayList<Text> textLines;
        block7: {
            if (!container.contains(Keys.SIGN_LINES.getQuery())) {
                return Optional.empty();
            }
            Preconditions.checkNotNull(signData);
            List<String> lines = container.getStringList(Keys.SIGN_LINES.getQuery()).get();
            textLines = Lists.newArrayListWithCapacity(4);
            try {
                if (lines.isEmpty()) {
                    for (int i = 0; i < 4; ++i) {
                        textLines.set(i, Text.of());
                    }
                    break block7;
                }
                int lineNum = 0;
                for (String line : lines) {
                    if (lineNum < 4) {
                        ++lineNum;
                        textLines.add(TextSerializers.JSON.deserialize(line));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new InvalidDataException("Could not translate text json lines", e);
            }
        }
        return Optional.of(signData.set(Keys.SIGN_LINES, textLines));
    }

    @Override
    protected boolean set(ItemStack itemStack, List<Text> lines) {
        NBTTagCompound signCompound = itemStack.func_190925_c("BlockEntityTag");
        signCompound.func_74778_a("id", "Sign");
        for (int i = 0; i < 4; ++i) {
            Text line;
            Text text = line = lines.size() > i ? lines.get(i) : Text.EMPTY;
            if (line == null) {
                throw new IllegalArgumentException("A null line was given at index " + i);
            }
            signCompound.func_74778_a("Text" + (i + 1), TextSerializers.JSON.serialize(line));
        }
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!this.supports(container)) {
            return DataTransactionResult.failNoData();
        }
        ItemStack itemStack = (ItemStack)container;
        Optional<List<Text>> old = this.getVal(itemStack);
        if (!old.isPresent()) {
            return DataTransactionResult.successNoData();
        }
        try {
            if (itemStack.func_77942_o()) {
                itemStack.func_77978_p().func_82580_o("BlockEntityTag");
            }
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        catch (Exception e) {
            return DataTransactionResult.builder().result(DataTransactionResult.Type.ERROR).build();
        }
    }

    @Override
    protected ListValue<Text> constructValue(List<Text> defaultValue) {
        return new SpongeListValue<Text>(Keys.SIGN_LINES, defaultValue);
    }

    @Override
    protected ImmutableValue<List<Text>> constructImmutableValue(List<Text> value) {
        return new ImmutableSpongeListValue<Text>(Keys.SIGN_LINES, ImmutableList.copyOf(value));
    }

    @Override
    protected SignData createManipulator() {
        return new SpongeSignData();
    }
}

