/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityNote;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableNoteData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.NoteData;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.type.NotePitches;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeNoteData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.type.SpongeNotePitch;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.registry.type.NotePitchRegistryModule;

public class NoteDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntityNote, NotePitch, Value<NotePitch>, NoteData, ImmutableNoteData> {
    public NoteDataProcessor() {
        super(TileEntityNote.class, Keys.NOTE_PITCH);
    }

    @Override
    protected boolean set(TileEntityNote entity, NotePitch value) {
        entity.field_145879_a = ((SpongeNotePitch)Preconditions.checkNotNull(value)).getByteId();
        entity.func_70296_d();
        return true;
    }

    @Override
    protected Optional<NotePitch> getVal(TileEntityNote entity) {
        return Optional.of(NotePitchRegistryModule.getPitch(entity.field_145879_a));
    }

    @Override
    protected Value<NotePitch> constructValue(NotePitch value) {
        return new SpongeValue<NotePitch>(Keys.NOTE_PITCH, NotePitches.F_SHARP0, value);
    }

    @Override
    protected ImmutableValue<NotePitch> constructImmutableValue(NotePitch value) {
        return ImmutableSpongeValue.cachedOf(Keys.NOTE_PITCH, NotePitches.F_SHARP0, value);
    }

    @Override
    protected NoteData createManipulator() {
        return new SpongeNoteData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

