/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityArmorStand;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableArmorStandData;
import org.spongepowered.api.data.manipulator.mutable.entity.ArmorStandData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeArmorStandData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.mixin.core.entity.item.EntityArmorStandAccessor;

public class ArmorStandDataProcessor
extends AbstractEntityDataProcessor<EntityArmorStand, ArmorStandData, ImmutableArmorStandData> {
    public ArmorStandDataProcessor() {
        super(EntityArmorStand.class);
    }

    @Override
    protected boolean doesDataExist(EntityArmorStand dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityArmorStand dataHolder, Map<Key<?>, Object> keyValues) {
        boolean hasArms = (Boolean)keyValues.get(Keys.ARMOR_STAND_HAS_ARMS);
        boolean hasBasePlate = (Boolean)keyValues.get(Keys.ARMOR_STAND_HAS_BASE_PLATE);
        boolean isSmall = (Boolean)keyValues.get(Keys.ARMOR_STAND_IS_SMALL);
        boolean isMarker = (Boolean)keyValues.get(Keys.ARMOR_STAND_MARKER);
        ((EntityArmorStandAccessor)dataHolder).accessor$setSmall(isSmall);
        ((EntityArmorStandAccessor)dataHolder).accessor$setMarker(isMarker);
        ((EntityArmorStandAccessor)dataHolder).accessor$setNoBasePlate(!hasBasePlate);
        ((EntityArmorStandAccessor)dataHolder).accessor$setShowArms(hasArms);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityArmorStand dataHolder) {
        return ImmutableMap.builder().put(Keys.ARMOR_STAND_HAS_ARMS, dataHolder.func_175402_q()).put(Keys.ARMOR_STAND_HAS_BASE_PLATE, !dataHolder.func_175414_r()).put(Keys.ARMOR_STAND_MARKER, dataHolder.func_181026_s()).put(Keys.ARMOR_STAND_IS_SMALL, dataHolder.func_175410_n()).build();
    }

    @Override
    protected ArmorStandData createManipulator() {
        return new SpongeArmorStandData();
    }

    @Override
    public Optional<ArmorStandData> fill(DataContainer container, ArmorStandData armorStandData) {
        if (container.contains(Keys.ARMOR_STAND_HAS_ARMS)) {
            armorStandData.set(Keys.ARMOR_STAND_HAS_ARMS, container.getBoolean(Keys.ARMOR_STAND_HAS_ARMS.getQuery()).get());
        }
        if (container.contains(Keys.ARMOR_STAND_MARKER)) {
            armorStandData.set(Keys.ARMOR_STAND_MARKER, container.getBoolean(Keys.ARMOR_STAND_MARKER.getQuery()).get());
        }
        if (container.contains(Keys.ARMOR_STAND_HAS_BASE_PLATE)) {
            armorStandData.set(Keys.ARMOR_STAND_HAS_BASE_PLATE, container.getBoolean(Keys.ARMOR_STAND_HAS_BASE_PLATE.getQuery()).get());
        }
        if (container.contains(Keys.ARMOR_STAND_IS_SMALL)) {
            armorStandData.set(Keys.ARMOR_STAND_IS_SMALL, container.getBoolean(Keys.ARMOR_STAND_IS_SMALL.getQuery()).get());
        }
        return Optional.of(armorStandData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

