/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvisibilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvisibilityData;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeInvisibilityData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;

public class InvisibilityDataProcessor
extends AbstractMultiDataSingleTargetProcessor<VanishableBridge, InvisibilityData, ImmutableInvisibilityData> {
    public InvisibilityDataProcessor() {
        super(VanishableBridge.class);
    }

    @Override
    protected InvisibilityData createManipulator() {
        return new SpongeInvisibilityData();
    }

    @Override
    protected boolean doesDataExist(VanishableBridge dataHolder) {
        return true;
    }

    @Override
    protected boolean set(VanishableBridge dataHolder, Map<Key<?>, Object> keyValues) {
        if (dataHolder instanceof Entity && ((Entity)dataHolder).field_70170_p.field_72995_K) {
            return false;
        }
        boolean invis = (Boolean)keyValues.get(Keys.INVISIBLE);
        boolean collision = (Boolean)keyValues.get(Keys.VANISH_IGNORES_COLLISION);
        boolean untargetable = (Boolean)keyValues.get(Keys.VANISH_PREVENTS_TARGETING);
        boolean vanish = (Boolean)keyValues.get(Keys.VANISH);
        dataHolder.bridge$setInvisible(invis);
        dataHolder.bridge$setVanished(vanish);
        dataHolder.bridge$setUncollideable(vanish && collision);
        dataHolder.bridge$setUntargetable(vanish && untargetable);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(VanishableBridge dataHolder) {
        return ImmutableMap.of(Keys.INVISIBLE, dataHolder.bridge$isInvisible(), Keys.VANISH, dataHolder.bridge$isVanished(), Keys.VANISH_IGNORES_COLLISION, dataHolder.bridge$isUncollideable(), Keys.VANISH_PREVENTS_TARGETING, dataHolder.bridge$isUntargetable());
    }

    @Override
    public Optional<InvisibilityData> fill(DataContainer container, InvisibilityData invisibilityData) {
        boolean vanished = container.getBoolean(Keys.VANISH.getQuery()).orElse(false);
        boolean invisible = container.getBoolean(Keys.INVISIBLE.getQuery()).orElse(false);
        boolean collision = container.getBoolean(Keys.VANISH_IGNORES_COLLISION.getQuery()).orElse(false);
        boolean targeting = container.getBoolean(Keys.VANISH_PREVENTS_TARGETING.getQuery()).orElse(false);
        return Optional.of(((InvisibilityData)((InvisibilityData)((InvisibilityData)invisibilityData.set(Keys.VANISH, vanished)).set(Keys.INVISIBLE, invisible)).set(Keys.VANISH_IGNORES_COLLISION, collision)).set(Keys.VANISH_PREVENTS_TARGETING, targeting));
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

