/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvulnerabilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvulnerabilityData;
import org.spongepowered.common.bridge.data.InvulnerableTrackedBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeInvulnerabilityData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;

public class InvulnerabilityDataProcessor
extends AbstractEntityDataProcessor<Entity, InvulnerabilityData, ImmutableInvulnerabilityData> {
    public InvulnerabilityDataProcessor() {
        super(Entity.class);
    }

    @Override
    protected boolean doesDataExist(Entity dataHolder) {
        return true;
    }

    @Override
    protected boolean set(Entity dataHolder, Map<Key<?>, Object> keyValues) {
        int invulnerabilityTicks = (Integer)keyValues.get(Keys.INVULNERABILITY_TICKS);
        boolean invulnerable = (Boolean)keyValues.get(Keys.INVULNERABLE);
        dataHolder.field_70172_ad = invulnerabilityTicks;
        if (dataHolder instanceof EntityLivingBase) {
            ((EntityLivingBase)dataHolder).field_70737_aN = invulnerabilityTicks;
        }
        ((InvulnerableTrackedBridge)dataHolder).bridge$setInvulnerable(invulnerable);
        return false;
    }

    @Override
    protected Map<Key<?>, ?> getValues(Entity dataHolder) {
        return ImmutableMap.builder().put(Keys.INVULNERABILITY_TICKS, dataHolder.field_70172_ad).put(Keys.INVULNERABLE, (Integer)((Object)Boolean.valueOf(dataHolder.func_190530_aW()))).build();
    }

    @Override
    protected InvulnerabilityData createManipulator() {
        return new SpongeInvulnerabilityData();
    }

    @Override
    public Optional<InvulnerabilityData> fill(DataContainer container, InvulnerabilityData invulnerabilityData) {
        if (container.contains(Keys.INVULNERABILITY_TICKS)) {
            invulnerabilityData.set(Keys.INVULNERABILITY_TICKS, container.getInt(Keys.INVULNERABILITY_TICKS.getQuery()).get());
        }
        if (container.contains(Keys.INVULNERABLE)) {
            invulnerabilityData.set(Keys.INVULNERABLE, container.getBoolean(Keys.INVULNERABLE.getQuery()).get());
        }
        return Optional.of(invulnerabilityData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

