/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.monster.EntityZombie;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAgeableData;
import org.spongepowered.api.data.manipulator.mutable.entity.AgeableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAgeableData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class ZombieAgeableDataProcessor
extends AbstractEntityDataProcessor<EntityZombie, AgeableData, ImmutableAgeableData> {
    public ZombieAgeableDataProcessor() {
        super(EntityZombie.class);
    }

    @Override
    protected AgeableData createManipulator() {
        return new SpongeAgeableData(0, true);
    }

    @Override
    protected boolean doesDataExist(EntityZombie entity) {
        return true;
    }

    @Override
    protected boolean set(EntityZombie entityCast, Map<Key<?>, Object> keyValues) {
        boolean adult = (Boolean)keyValues.get(Keys.IS_ADULT);
        EntityZombie entity = entityCast;
        entity.func_82227_f(!adult);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityZombie entity) {
        int age = entity.func_70631_g_() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        boolean adult = !entity.func_70631_g_();
        return ImmutableMap.of(Keys.AGE, age, Keys.IS_ADULT, adult);
    }

    @Override
    public Optional<AgeableData> fill(DataContainer container, AgeableData ageableData) {
        if (!container.contains(Keys.AGE.getQuery()) || !container.contains(Keys.IS_ADULT.getQuery())) {
            return Optional.empty();
        }
        ageableData.set(Keys.AGE, DataUtil.getData(container, Keys.AGE));
        ageableData.set(Keys.IS_ADULT, DataUtil.getData(container, Keys.IS_ADULT));
        return Optional.of(ageableData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

