/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBeaconData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BeaconData;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeBeaconData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;
import org.spongepowered.common.mixin.core.tileentity.TileEntityBeaconAccessor;

public class BeaconDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityBeacon, BeaconData, ImmutableBeaconData> {
    public BeaconDataProcessor() {
        super(TileEntityBeacon.class);
    }

    @Override
    protected boolean doesDataExist(TileEntityBeacon dataHolder) {
        return true;
    }

    @Override
    protected boolean set(TileEntityBeacon dataHolder, Map<Key<?>, Object> keyValues) {
        Potion primary = ((Optional)keyValues.get(Keys.BEACON_PRIMARY_EFFECT)).orElse(null);
        Potion secondary = ((Optional)keyValues.get(Keys.BEACON_SECONDARY_EFFECT)).orElse(null);
        ((TileEntityBeaconAccessor)dataHolder).accessor$setPrimaryEffect(primary);
        ((TileEntityBeaconAccessor)dataHolder).accessor$setSecondaryEffect(secondary);
        dataHolder.func_70296_d();
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityBeacon dataHolder) {
        ImmutableMap.Builder<Key<OptionalValue<PotionEffectType>>, Optional<Potion>> builder = ImmutableMap.builder();
        int primaryID = dataHolder.func_174887_a_(1);
        int secondaryID = dataHolder.func_174887_a_(2);
        if (primaryID > 0) {
            builder.put(Keys.BEACON_PRIMARY_EFFECT, Optional.ofNullable(Potion.func_188412_a((int)primaryID)));
        }
        if (secondaryID > 0 && dataHolder.func_174887_a_(0) == 4) {
            builder.put(Keys.BEACON_SECONDARY_EFFECT, Optional.ofNullable(Potion.func_188412_a((int)secondaryID)));
        }
        return builder.build();
    }

    @Override
    protected BeaconData createManipulator() {
        return new SpongeBeaconData();
    }

    @Override
    public Optional<BeaconData> fill(DataContainer container, BeaconData beaconData) {
        PotionEffectType type;
        if (!container.contains(Keys.BEACON_PRIMARY_EFFECT.getQuery()) && !container.contains(Keys.BEACON_SECONDARY_EFFECT.getQuery())) {
            return Optional.of(beaconData);
        }
        if (container.contains(Keys.BEACON_PRIMARY_EFFECT.getQuery())) {
            type = Sponge.getRegistry().getType(PotionEffectType.class, container.getString(Keys.BEACON_PRIMARY_EFFECT.getQuery()).get()).get();
            beaconData.primaryEffect().set(Optional.of(type));
        }
        if (container.contains(Keys.BEACON_SECONDARY_EFFECT.getQuery())) {
            type = Sponge.getRegistry().getType(PotionEffectType.class, container.getString(Keys.BEACON_SECONDARY_EFFECT.getQuery()).get()).get();
            beaconData.secondaryEffect().set(Optional.of(type));
        }
        return Optional.of(beaconData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

