/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.block;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.tileentity.TileEntityChest;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;

public class ConnectedDirectionsValueProcessor
extends AbstractSpongeValueProcessor<TileEntityChest, Set<Direction>, SetValue<Direction>> {
    public ConnectedDirectionsValueProcessor() {
        super(TileEntityChest.class, Keys.CONNECTED_DIRECTIONS);
    }

    @Override
    protected SetValue<Direction> constructValue(Set<Direction> defaultValue) {
        return new SpongeSetValue<Direction>((Key<BaseValue<Set<Direction>>>)Keys.CONNECTED_DIRECTIONS, Sets.newHashSet(), defaultValue);
    }

    @Override
    protected boolean set(TileEntityChest container, Set<Direction> value) {
        return false;
    }

    @Override
    protected Optional<Set<Direction>> getVal(TileEntityChest chest) {
        chest.func_145979_i();
        HashSet<Direction> directions = Sets.newHashSet();
        if (chest.field_145992_i != null) {
            directions.add(Direction.NORTH);
        }
        if (chest.field_145990_j != null) {
            directions.add(Direction.EAST);
        }
        if (chest.field_145988_l != null) {
            directions.add(Direction.SOUTH);
        }
        if (chest.field_145991_k != null) {
            directions.add(Direction.WEST);
        }
        return Optional.of(directions);
    }

    @Override
    protected ImmutableValue<Set<Direction>> constructImmutableValue(Set<Direction> value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

