/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.player.PlayerCapabilitiesAccessor;

public class WalkingSpeedValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Double, Value<Double>> {
    public WalkingSpeedValueProcessor() {
        super(EntityPlayer.class, Keys.WALKING_SPEED);
    }

    @Override
    protected Value<Double> constructValue(Double defaultValue) {
        return new SpongeValue<Double>(Keys.WALKING_SPEED, 0.7);
    }

    @Override
    protected ImmutableValue<Double> constructImmutableValue(Double value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected boolean set(EntityPlayer container, Double value) {
        WalkingSpeedValueProcessor.setWalkSpeed(container, value);
        container.func_71016_p();
        return true;
    }

    @Override
    protected Optional<Double> getVal(EntityPlayer container) {
        return Optional.of(Double.valueOf(container.field_71075_bZ.func_75094_b()));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    public static void setWalkSpeed(EntityPlayer container, double value) {
        ((PlayerCapabilitiesAccessor)container.field_71075_bZ).accessor$setWalkSpeed((float)value);
        IAttributeInstance attribute = container.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attribute.func_111128_a(value);
    }
}

