/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.data.property.PropertyRegistry;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.common.data.property.PropertyStoreDelegate;
import org.spongepowered.common.util.Constants;

@Singleton
public class SpongePropertyRegistry
implements PropertyRegistry {
    @Nullable
    private TempRegistry tempRegistry = new TempRegistry();
    private final Map<Class<? extends Property<?, ?>>, PropertyStoreDelegate<?>> delegateMap = Maps.newConcurrentMap();

    public void completeRegistration() {
        Preconditions.checkState(this.tempRegistry != null, "PropertyRegistry already finalized");
        TempRegistry temp = this.tempRegistry;
        this.tempRegistry = null;
        if (temp != null) {
            for (Map.Entry<Class<Property<?, ?>>, List<PropertyStore<?>>> entry : temp.propertyStoreMap.entrySet()) {
                ImmutableList.Builder propertyStoreBuilder = ImmutableList.builder();
                entry.getValue().sort(Constants.Functional.PROPERTY_STORE_COMPARATOR);
                propertyStoreBuilder.addAll(entry.getValue());
                PropertyStoreDelegate delegate = new PropertyStoreDelegate(propertyStoreBuilder.build());
                this.delegateMap.put(entry.getKey(), delegate);
            }
            temp.delegateMap.clear();
            temp.propertyStoreMap.clear();
        }
    }

    @Override
    public <T extends Property<?, ?>> void register(Class<T> propertyClass, PropertyStore<T> propertyStore) {
        Preconditions.checkState(this.tempRegistry != null, "Registrations are no longer allowed!");
        Preconditions.checkArgument(propertyClass != null, "The property class can not be null!");
        if (!this.tempRegistry.propertyStoreMap.containsKey(propertyClass)) {
            this.tempRegistry.propertyStoreMap.put(propertyClass, Collections.synchronizedList(Lists.newArrayList()));
        }
        this.tempRegistry.delegateMap.remove(propertyClass);
        List<PropertyStore<?>> propertyStores = this.tempRegistry.propertyStoreMap.get(propertyClass);
        propertyStores.add(Preconditions.checkNotNull(propertyStore));
    }

    @Override
    public <T extends Property<?, ?>> Optional<PropertyStore<T>> getStore(Class<T> propertyClass) {
        Preconditions.checkArgument(propertyClass != null, "The property class can not be null!");
        if (!this.delegateMap.containsKey(propertyClass)) {
            return Optional.empty();
        }
        return Optional.of((PropertyStore)this.delegateMap.get(propertyClass));
    }

    public Collection<Property<?, ?>> getPropertiesFor(PropertyHolder holder) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.tempRegistry != null) {
            HashSet used = new HashSet();
            for (Map.Entry<Class<Property<?, ?>>, PropertyStoreDelegate<?>> entry : this.tempRegistry.delegateMap.entrySet()) {
                used.add(entry.getKey());
                entry.getValue().getFor(holder).ifPresent(builder::add);
            }
            for (Map.Entry<Class<Property<?, ?>>, Object> entry : this.tempRegistry.propertyStoreMap.entrySet()) {
                if (used.contains(entry.getKey())) continue;
                used.add(entry.getKey());
                ImmutableList.Builder propertyStoreBuilder = ImmutableList.builder();
                ((List)entry.getValue()).sort(Constants.Functional.PROPERTY_STORE_COMPARATOR);
                propertyStoreBuilder.addAll((Iterable)entry.getValue());
                PropertyStoreDelegate delegate = new PropertyStoreDelegate(propertyStoreBuilder.build());
                this.tempRegistry.delegateMap.put(entry.getKey(), delegate);
                delegate.getFor(holder).ifPresent(builder::add);
            }
            return builder.build();
        }
        for (Map.Entry<Class<Property<?, ?>>, PropertyStoreDelegate<?>> entry : this.delegateMap.entrySet()) {
            entry.getValue().getFor(holder).ifPresent(builder::add);
        }
        return builder.build();
    }

    static final class TempRegistry {
        final Map<Class<? extends Property<?, ?>>, List<PropertyStore<?>>> propertyStoreMap = Maps.newConcurrentMap();
        final Map<Class<? extends Property<?, ?>>, PropertyStoreDelegate<?>> delegateMap = Maps.newConcurrentMap();

        TempRegistry() {
        }
    }
}

