/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;

public abstract class AbstractBaseValue<E>
implements BaseValue<E> {
    private final Key<? extends BaseValue<E>> key;
    private final E defaultValue;
    protected E actualValue;

    public AbstractBaseValue(Key<? extends BaseValue<E>> key, E defaultValue) {
        this.key = Preconditions.checkNotNull(key);
        this.defaultValue = Preconditions.checkNotNull(defaultValue);
        this.actualValue = defaultValue;
    }

    protected AbstractBaseValue(Key<? extends BaseValue<E>> key, E defaultValue, E actualValue) {
        this.key = Preconditions.checkNotNull(key);
        this.defaultValue = Preconditions.checkNotNull(defaultValue);
        this.actualValue = Preconditions.checkNotNull(actualValue);
    }

    @Override
    public E get() {
        return this.actualValue == null ? this.defaultValue : this.actualValue;
    }

    @Override
    public boolean exists() {
        return this.actualValue != null;
    }

    @Override
    public E getDefault() {
        return this.defaultValue;
    }

    @Override
    public Optional<E> getDirect() {
        return Optional.ofNullable(this.actualValue);
    }

    @Override
    public Key<? extends BaseValue<E>> getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.defaultValue, this.actualValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBaseValue other = (AbstractBaseValue)obj;
        return Objects.equal(this.key, other.key) && Objects.equal(this.defaultValue, other.defaultValue) && Objects.equal(this.actualValue, other.actualValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("key", this.key).add("defaultValue", this.defaultValue).add("actualValue", this.actualValue).toString();
    }
}

