/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BoundedValue;
import org.spongepowered.api.data.value.ValueFactory;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.value.mutable.SpongeBoundedValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeValueFactory
implements ValueFactory {
    private static ValueFactory instance = new SpongeValueFactory();

    public static ValueFactory getInstance() {
        return instance;
    }

    @Override
    public <E> Value<E> createValue(Key<Value<E>> key, E element) {
        return new SpongeValue<E>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(element, "element"));
    }

    @Override
    public <E> Value<E> createValue(Key<Value<E>> key, E element, E defaultValue) {
        return new SpongeValue<E>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(defaultValue, "defaultValue"), Preconditions.checkNotNull(element, "element"));
    }

    @Override
    public <E> ListValue<E> createListValue(Key<ListValue<E>> key, List<E> elements) {
        return new SpongeListValue(Preconditions.checkNotNull(key, "key"), Lists.newArrayList(), Lists.newArrayList(elements));
    }

    @Override
    public <E> ListValue<E> createListValue(Key<ListValue<E>> key, List<E> elements, List<E> defaults) {
        return new SpongeListValue<E>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(defaults, "defaults"), Preconditions.checkNotNull(elements));
    }

    @Override
    public <E> SetValue<E> createSetValue(Key<SetValue<E>> key, Set<E> elements) {
        return new SpongeSetValue<E>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(elements, "elements"));
    }

    @Override
    public <E> SetValue<E> createSetValue(Key<SetValue<E>> key, Set<E> elements, Set<E> defaults) {
        return new SpongeSetValue<E>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(defaults, "defaults"), Preconditions.checkNotNull(elements, "elements"));
    }

    @Override
    public <K, V> MapValue<K, V> createMapValue(Key<MapValue<K, V>> key, Map<K, V> map) {
        return new SpongeMapValue<K, V>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(map, "map"));
    }

    @Override
    public <K, V> MapValue<K, V> createMapValue(Key<MapValue<K, V>> key, Map<K, V> map, Map<K, V> defaults) {
        return new SpongeMapValue<K, V>(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(defaults, "defaults"), Preconditions.checkNotNull(map, "map"));
    }

    @Override
    public <E> ValueFactory.BoundedValueBuilder<E> createBoundedValueBuilder(Key<MutableBoundedValue<E>> key) {
        return new SpongeBoundedValueBuilder<E>(Preconditions.checkNotNull(key));
    }

    @Override
    public <E> OptionalValue<E> createOptionalValue(Key<OptionalValue<E>> key, @Nullable E element) {
        return new SpongeOptionalValue(Preconditions.checkNotNull(key, "key"), Optional.empty(), Optional.ofNullable(element));
    }

    @Override
    public <E> OptionalValue<E> createOptionalValue(Key<OptionalValue<E>> key, @Nullable E element, E defaultElement) {
        return new SpongeOptionalValue<E>(Preconditions.checkNotNull(key, "key"), Optional.of(defaultElement), Optional.ofNullable(element));
    }

    public static <E> ValueFactory.BoundedValueBuilder<E> boundedBuilder(Key<? extends BoundedValue<E>> key) {
        return new SpongeBoundedValueBuilder(Preconditions.checkNotNull(key));
    }

    private SpongeValueFactory() {
    }

    public static final class SpongeBoundedValueBuilder<E>
    implements ValueFactory.BoundedValueBuilder<E> {
        private final Key<? extends BoundedValue<E>> key;
        private Comparator<E> comparator;
        private E minimum;
        private E maximum;
        private E defaultValue;
        private E value;

        public SpongeBoundedValueBuilder(Key<? extends BoundedValue<E>> key) {
            this.key = Preconditions.checkNotNull(key);
        }

        @Override
        public ValueFactory.BoundedValueBuilder<E> comparator(Comparator<E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
            return this;
        }

        @Override
        public ValueFactory.BoundedValueBuilder<E> minimum(E minimum) {
            this.minimum = Preconditions.checkNotNull(minimum);
            if (this.comparator == null && minimum instanceof Comparable) {
                this.comparator = (o1, o2) -> ((Comparable)o1).compareTo(o2);
            }
            return this;
        }

        @Override
        public ValueFactory.BoundedValueBuilder<E> maximum(E maximum) {
            this.maximum = Preconditions.checkNotNull(maximum);
            if (this.comparator == null && maximum instanceof Comparable) {
                this.comparator = (o1, o2) -> ((Comparable)o1).compareTo(o2);
            }
            return this;
        }

        @Override
        public ValueFactory.BoundedValueBuilder<E> defaultValue(E defaultValue) {
            this.defaultValue = Preconditions.checkNotNull(defaultValue);
            return this;
        }

        @Override
        public ValueFactory.BoundedValueBuilder<E> actualValue(E value) {
            this.value = Preconditions.checkNotNull(value);
            return this;
        }

        @Override
        public SpongeBoundedValue<E> build() {
            Preconditions.checkState(this.comparator != null);
            Preconditions.checkState(this.minimum != null);
            Preconditions.checkState(this.maximum != null);
            Preconditions.checkState(this.defaultValue != null);
            if (this.value == null) {
                return new SpongeBoundedValue<E>(this.key, this.defaultValue, this.comparator, this.minimum, this.maximum);
            }
            return new SpongeBoundedValue<E>(this.key, this.defaultValue, this.comparator, this.minimum, this.maximum, this.value);
        }
    }
}

