/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeItemValue;

public class ImmutableSpongeItemValue
extends ImmutableSpongeValue<ItemStack> {
    public ImmutableSpongeItemValue(Key<? extends BaseValue<ItemStack>> key, ItemStack defaultValue) {
        super(key, defaultValue.copy());
    }

    public ImmutableSpongeItemValue(Key<? extends BaseValue<ItemStack>> key, ItemStack defaultValue, ItemStack actualValue) {
        super(key, defaultValue.copy(), actualValue.copy());
    }

    @Override
    public ImmutableValue<ItemStack> with(ItemStack value) {
        return super.with(value.copy());
    }

    @Override
    public ImmutableValue<ItemStack> transform(Function<ItemStack, ItemStack> function) {
        ItemStack value = Preconditions.checkNotNull(function).apply(this.get());
        return new ImmutableSpongeItemValue(this.getKey(), this.getDefault(), Preconditions.checkNotNull(value));
    }

    @Override
    public Value<ItemStack> asMutable() {
        return new SpongeItemValue(this.getKey(), this.getDefault(), this.get());
    }

    @Override
    public ItemStack get() {
        return ((ItemStack)super.get()).copy();
    }

    @Override
    public ItemStack getDefault() {
        return ((ItemStack)super.getDefault()).copy();
    }
}

