/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;

public class ImmutableSpongeMapValue<K, V>
extends ImmutableSpongeValue<Map<K, V>>
implements ImmutableMapValue<K, V> {
    public ImmutableSpongeMapValue(Key<? extends BaseValue<Map<K, V>>> key) {
        this(key, ImmutableMap.of());
    }

    public ImmutableSpongeMapValue(Key<? extends BaseValue<Map<K, V>>> key, Map<K, V> actualValue) {
        super(key, ImmutableMap.of(), ImmutableMap.copyOf(actualValue));
    }

    @Override
    public ImmutableMapValue<K, V> with(Map<K, V> value) {
        return new ImmutableSpongeMapValue<K, V>(this.getKey(), Preconditions.checkNotNull(value));
    }

    @Override
    public ImmutableMapValue<K, V> transform(Function<Map<K, V>, Map<K, V>> function) {
        return new ImmutableSpongeMapValue<K, V>(this.getKey(), Preconditions.checkNotNull(Preconditions.checkNotNull(function).apply((Map<K, V>)this.actualValue)));
    }

    @Override
    public MapValue<K, V> asMutable() {
        HashMap map = Maps.newHashMap();
        map.putAll((Map)this.actualValue);
        return new SpongeMapValue(this.getKey(), map);
    }

    @Override
    public int size() {
        return ((Map)this.actualValue).size();
    }

    @Override
    public ImmutableMapValue<K, V> with(K key, V value) {
        return new ImmutableSpongeMapValue(this.getKey(), ImmutableMap.builder().putAll((Map)this.actualValue).put(Preconditions.checkNotNull(key), Preconditions.checkNotNull(value)).build());
    }

    @Override
    public ImmutableMapValue<K, V> withAll(Map<K, V> map) {
        return new ImmutableSpongeMapValue(this.getKey(), ImmutableMap.builder().putAll((Map)this.actualValue).putAll(map).build());
    }

    @Override
    public ImmutableMapValue<K, V> without(K key) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ((Map)this.actualValue).entrySet().stream().filter(entry -> !entry.getKey().equals(key)).forEach(entry -> builder.put(entry.getKey(), entry.getValue()));
        return new ImmutableSpongeMapValue(this.getKey(), builder.build());
    }

    @Override
    public ImmutableMapValue<K, V> withoutAll(Iterable<K> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ((Map)this.actualValue).entrySet().stream().filter(entry -> !Iterables.contains(keys, entry.getKey())).forEach(entry -> builder.put(entry.getKey(), entry.getValue()));
        return new ImmutableSpongeMapValue(this.getKey(), builder.build());
    }

    @Override
    public ImmutableMapValue<K, V> withoutAll(Predicate<Map.Entry<K, V>> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ((Map)this.actualValue).entrySet().stream().filter(entry -> Preconditions.checkNotNull(predicate).test(entry)).forEach(entry -> builder.put(entry.getKey(), entry.getValue()));
        return new ImmutableSpongeMapValue(this.getKey(), builder.build());
    }

    @Override
    public boolean containsKey(K key) {
        return ((Map)this.actualValue).containsKey(Preconditions.checkNotNull(key));
    }

    @Override
    public boolean containsValue(V value) {
        return ((Map)this.actualValue).containsValue(Preconditions.checkNotNull(value));
    }

    @Override
    public ImmutableSet<K> keySet() {
        return (ImmutableSet)((Map)this.actualValue).keySet();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return (ImmutableSet)((Map)this.actualValue).entrySet();
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)((Map)this.actualValue).values();
    }
}

