/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.function.Function;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeBoundedValue<E>
extends SpongeValue<E>
implements MutableBoundedValue<E> {
    private final Comparator<E> comparator;
    private final E minimum;
    private final E maximum;

    public SpongeBoundedValue(Key<? extends BaseValue<E>> key, E defaultValue, Comparator<E> comparator, E minimum, E maximum) {
        this(key, defaultValue, comparator, minimum, maximum, defaultValue);
    }

    public SpongeBoundedValue(Key<? extends BaseValue<E>> key, E defaultValue, Comparator<E> comparator, E minimum, E maximum, E actualValue) {
        super(key, defaultValue, actualValue);
        this.comparator = Preconditions.checkNotNull(comparator);
        this.minimum = Preconditions.checkNotNull(minimum);
        this.maximum = Preconditions.checkNotNull(maximum);
        Preconditions.checkState(comparator.compare(maximum, minimum) >= 0);
    }

    @Override
    public E getMinValue() {
        return this.minimum;
    }

    @Override
    public E getMaxValue() {
        return this.maximum;
    }

    @Override
    public Comparator<E> getComparator() {
        return this.comparator;
    }

    @Override
    public MutableBoundedValue<E> set(E value) {
        if (this.comparator.compare(value, this.minimum) >= 0 && this.comparator.compare(value, this.maximum) <= 0) {
            this.actualValue = Preconditions.checkNotNull(value);
        }
        return this;
    }

    @Override
    public MutableBoundedValue<E> transform(Function<E, E> function) {
        return this.set((Object)Preconditions.checkNotNull(Preconditions.checkNotNull(function).apply(this.get())));
    }

    @Override
    public ImmutableBoundedValue<E> asImmutable() {
        return new ImmutableSpongeBoundedValue<Object>(this.getKey(), this.getDefault(), this.actualValue, this.comparator, this.minimum, this.maximum);
    }

    @Override
    public MutableBoundedValue<E> copy() {
        return new SpongeBoundedValue<Object>(this.getKey(), this.getDefault(), this.comparator, this.minimum, this.maximum, this.actualValue);
    }
}

