/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableListValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeCollectionValue;

public class SpongeListValue<E>
extends SpongeCollectionValue<E, List<E>, ListValue<E>, ImmutableListValue<E>>
implements ListValue<E> {
    public SpongeListValue(Key<? extends BaseValue<List<E>>> key) {
        super(key, Lists.newArrayList());
    }

    public SpongeListValue(Key<? extends BaseValue<List<E>>> key, List<E> defaultList, List<E> actualList) {
        super(key, Lists.newArrayList(defaultList), Lists.newArrayList(actualList));
    }

    public SpongeListValue(Key<? extends BaseValue<List<E>>> key, List<E> actualValue) {
        this(key, Lists.newArrayList(), actualValue);
    }

    @Override
    public ListValue<E> transform(Function<List<E>, List<E>> function) {
        this.actualValue = Lists.newArrayList((Iterable)Preconditions.checkNotNull(function.apply((List<E>)this.actualValue)));
        return this;
    }

    @Override
    public ListValue<E> filter(Predicate<? super E> predicate) {
        ArrayList list = Lists.newArrayList();
        list.addAll(((List)this.actualValue).stream().filter((? super T element) -> Preconditions.checkNotNull(predicate).test(element)).collect(Collectors.toList()));
        return new SpongeListValue(this.getKey(), list);
    }

    @Override
    public List<E> getAll() {
        return Lists.newArrayList((Iterable)this.actualValue);
    }

    @Override
    public ImmutableListValue<E> asImmutable() {
        return new ImmutableSpongeListValue(this.getKey(), ImmutableList.copyOf((Collection)this.actualValue));
    }

    @Override
    public ListValue<E> copy() {
        return new SpongeListValue(this.getKey(), (List)this.getDefault(), Lists.newArrayList((Iterable)this.actualValue));
    }

    @Override
    public E get(int index) {
        return ((List)this.actualValue).get(index);
    }

    @Override
    public ListValue<E> add(int index, E value) {
        ((List)this.actualValue).add(index, Preconditions.checkNotNull(value));
        return this;
    }

    @Override
    public ListValue<E> add(int index, Iterable<E> values) {
        int count = 0;
        Iterator<E> iterator = values.iterator();
        while (iterator.hasNext()) {
            ((List)this.actualValue).add(index + count, Preconditions.checkNotNull(iterator.next()));
            ++count;
        }
        return this;
    }

    @Override
    public ListValue<E> remove(int index) {
        ((List)this.actualValue).remove(index);
        return this;
    }

    @Override
    public ListValue<E> set(int index, E element) {
        ((List)this.actualValue).set(index, Preconditions.checkNotNull(element));
        return this;
    }

    @Override
    public int indexOf(E element) {
        return ((List)this.actualValue).indexOf(Preconditions.checkNotNull(element));
    }
}

