/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeOptionalValue<E>
extends SpongeValue<Optional<E>>
implements OptionalValue<E> {
    public SpongeOptionalValue(Key<? extends BaseValue<Optional<E>>> key) {
        this(key, Optional.empty());
    }

    public SpongeOptionalValue(Key<? extends BaseValue<Optional<E>>> key, Optional<E> actualValue) {
        this(key, Optional.empty(), actualValue);
    }

    public SpongeOptionalValue(Key<? extends BaseValue<Optional<E>>> key, Optional<E> defaultValue, Optional<E> actualValue) {
        super(key, defaultValue, actualValue);
    }

    @Override
    public OptionalValue<E> set(Optional<E> value) {
        this.actualValue = Preconditions.checkNotNull(value);
        return this;
    }

    @Override
    public OptionalValue<E> transform(Function<Optional<E>, Optional<E>> function) {
        this.actualValue = Preconditions.checkNotNull(function.apply((Optional<E>)this.actualValue));
        return this;
    }

    @Override
    public ImmutableOptionalValue<E> asImmutable() {
        return new ImmutableSpongeOptionalValue(this.getKey(), (Optional)this.actualValue);
    }

    @Override
    public OptionalValue<E> copy() {
        return new SpongeOptionalValue<E>(this.getKey(), (Optional)this.actualValue);
    }

    @Override
    public OptionalValue<E> setTo(@Nullable E value) {
        return this.set(Optional.ofNullable(value));
    }

    @Override
    public Value<E> or(E defaultValue) {
        return new SpongeValue<Object>(null, null, (((Optional)this.get()).isPresent() ? ((Optional)this.get()).get() : Preconditions.checkNotNull(defaultValue)));
    }
}

