/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;
import org.spongepowered.common.data.value.mutable.SpongeCollectionValue;

public class SpongeSetValue<E>
extends SpongeCollectionValue<E, Set<E>, SetValue<E>, ImmutableSetValue<E>>
implements SetValue<E> {
    public SpongeSetValue(Key<? extends BaseValue<Set<E>>> key) {
        this(key, Sets.newHashSet());
    }

    public SpongeSetValue(Key<? extends BaseValue<Set<E>>> key, Set<E> actualValue) {
        this(key, Sets.newHashSet(), actualValue);
    }

    public SpongeSetValue(Key<? extends BaseValue<Set<E>>> key, Set<E> defaultSet, Set<E> actualValue) {
        super(key, Sets.newHashSet(defaultSet), Sets.newHashSet(actualValue));
    }

    @Override
    public SetValue<E> transform(Function<Set<E>, Set<E>> function) {
        this.actualValue = Sets.newHashSet((Iterable)Preconditions.checkNotNull(Preconditions.checkNotNull(function).apply((Set<E>)this.actualValue)));
        return this;
    }

    @Override
    public SetValue<E> filter(Predicate<? super E> predicate) {
        HashSet set = Sets.newHashSet();
        set.addAll(((Set)this.actualValue).stream().filter((? super T element) -> Preconditions.checkNotNull(predicate).test(element)).collect(Collectors.toList()));
        return new SpongeSetValue(this.getKey(), set);
    }

    @Override
    public Set<E> getAll() {
        return Sets.newHashSet((Iterable)this.actualValue);
    }

    @Override
    public ImmutableSetValue<E> asImmutable() {
        return new ImmutableSpongeSetValue(this.getKey(), ImmutableSet.copyOf((Collection)this.actualValue));
    }

    @Override
    public SetValue<E> copy() {
        return new SpongeSetValue<E>(this.getKey(), (Set)this.getDefault(), (Set)this.actualValue);
    }
}

