/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleOption;
import org.spongepowered.common.effect.particle.SpongeParticleType;
import org.spongepowered.common.util.Constants;

public class SpongeParticleEffectBuilder
extends AbstractDataBuilder<ParticleEffect>
implements ParticleEffect.Builder {
    private SpongeParticleType type;
    private Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffectBuilder() {
        super(ParticleEffect.class, 1);
        this.reset();
    }

    @Override
    protected Optional<ParticleEffect> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Particles.PARTICLE_TYPE, Constants.Particles.PARTICLE_OPTIONS)) {
            return Optional.empty();
        }
        ParticleType particleType = container.getCatalogType(Constants.Particles.PARTICLE_TYPE, ParticleType.class).get();
        HashMap options = new HashMap();
        container.getViewList(Constants.Particles.PARTICLE_OPTIONS).get().forEach(view -> {
            ParticleOption option = view.getCatalogType(Constants.Particles.PARTICLE_OPTION_KEY, ParticleOption.class).get();
            Object value = option.getValueType().isAssignableFrom(DataSerializable.class) ? view.getSerializable(Constants.Particles.PARTICLE_OPTION_VALUE, option.getValueType()).get() : view.getObject(Constants.Particles.PARTICLE_OPTION_VALUE, option.getValueType()).get();
            options.put(option, value);
        });
        return Optional.of(new SpongeParticleEffect((SpongeParticleType)particleType, options));
    }

    @Override
    public ParticleEffect.Builder from(ParticleEffect particleEffect) {
        this.type = (SpongeParticleType)particleEffect.getType();
        this.options = new HashMap(particleEffect.getOptions());
        return this;
    }

    @Override
    public ParticleEffect.Builder type(ParticleType particleType) {
        this.type = (SpongeParticleType)Preconditions.checkNotNull(particleType, "particleType");
        return this;
    }

    @Override
    public ParticleEffect.Builder reset() {
        super.reset();
        this.type = null;
        this.options = new HashMap();
        return this;
    }

    @Override
    public <V> ParticleEffect.Builder option(ParticleOption<V> option, V value) throws IllegalArgumentException {
        Preconditions.checkNotNull(option, "option");
        Preconditions.checkNotNull(value, "value");
        IllegalArgumentException exception = ((SpongeParticleOption)option).validateValue(value);
        if (exception != null) {
            throw exception;
        }
        if (value instanceof List) {
            value = ImmutableList.copyOf((List)value);
        }
        this.options.put(option, value);
        return this;
    }

    @Override
    public ParticleEffect build() {
        Preconditions.checkArgument(this.type != null, "ParticleType must be set");
        return new SpongeParticleEffect(this.type, this.options);
    }
}

