/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.record;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class SpongeRecordType
extends SpongeCatalogType.Translatable
implements RecordType {
    private static final int EFFECT_ID = 1010;
    private final ItemType recordItem;
    private final SoundType soundType;

    public SpongeRecordType(String id, String translation, ItemType recordItem, SoundType soundType) {
        super(id, new SpongeTranslation(translation));
        this.recordItem = recordItem;
        this.soundType = soundType;
    }

    public int getInternalId() {
        return Item.field_150901_e.func_148757_b((Object)((Item)this.recordItem));
    }

    @Override
    public SoundType getSound() {
        return this.soundType;
    }

    public static SPacketEffect createPacket(Vector3i position, @Nullable RecordType recordType) {
        Preconditions.checkNotNull(position, "position");
        BlockPos pos = new BlockPos(position.getX(), position.getY(), position.getZ());
        return new SPacketEffect(1010, pos, recordType == null ? 0 : ((SpongeRecordType)recordType).getInternalId(), false);
    }
}

