/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.EntityTrackerCategory;
import org.spongepowered.common.config.category.EntityTrackerModCategory;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class SpongeEntityType
extends SpongeCatalogType.Translatable
implements EntityType {
    public static final EntityType UNKNOWN = new SpongeEntityType(-999999, "Unknown", "unknown", Entity.class, (Translation)new SpongeTranslation("entity.generic.name")){

        @Override
        public String getName() {
            return "Unknown";
        }

        @Override
        public Class<? extends org.spongepowered.api.entity.Entity> getEntityClass() {
            throw new UnsupportedOperationException("Unknown entity type has no entity class");
        }

        @Override
        public void initializeTrackerState() {
        }

        @Override
        public boolean isKnown() {
            return false;
        }
    };
    public final int entityTypeId;
    public final String entityName;
    public final String modId;
    public final Class<? extends Entity> entityClass;
    private final boolean isVanilla;
    private EnumCreatureType creatureType;
    private boolean activationRangeInitialized = false;
    @Nullable
    private Timing timing = null;
    public boolean allowsBlockBulkCapture = true;
    public boolean allowsEntityBulkCapture = true;
    public boolean allowsBlockEventCreation = true;
    public boolean allowsEntityEventCreation = true;
    public boolean isModdedDamageEntityMethod = false;

    public SpongeEntityType(int id, String name, Class<? extends Entity> clazz, Translation translation) {
        this(id, name.toLowerCase(Locale.ENGLISH), "minecraft", clazz, translation);
    }

    public SpongeEntityType(int id, String name, String modId, Class<? extends Entity> clazz, Translation translation) {
        super(modId.toLowerCase(Locale.ENGLISH) + ":" + name.toLowerCase(Locale.ENGLISH), SpongeEntityType.check(translation));
        this.entityTypeId = id;
        this.entityName = name.toLowerCase(Locale.ENGLISH);
        this.entityClass = clazz;
        this.modId = modId.toLowerCase(Locale.ENGLISH);
        this.isVanilla = this.entityClass.getName().startsWith("net.minecraft.");
        this.initializeTrackerState();
    }

    private static Translation check(@Nullable Translation translation) {
        if (translation == null) {
            return UNKNOWN.getTranslation();
        }
        return translation;
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    public String getModId() {
        return this.modId;
    }

    @Nullable
    public EnumCreatureType getEnumCreatureType() {
        return this.creatureType;
    }

    public void setEnumCreatureType(EnumCreatureType type) {
        this.creatureType = type;
    }

    public boolean isActivationRangeInitialized() {
        return this.activationRangeInitialized;
    }

    public void setActivationRangeInitialized(boolean flag) {
        this.activationRangeInitialized = flag;
    }

    public void initializeTrackerState() {
        SpongeConfig<TrackerConfig> trackerConfigAdapter = SpongeImpl.getTrackerConfigAdapter();
        EntityTrackerCategory entityTrackerCat = trackerConfigAdapter.getConfig().getEntityTracker();
        EntityTrackerModCategory entityTrackerModCat = entityTrackerCat.getModMappings().get(this.modId);
        if (entityTrackerModCat == null) {
            entityTrackerModCat = new EntityTrackerModCategory();
            entityTrackerCat.getModMappings().put(this.modId, entityTrackerModCat);
        }
        if (!entityTrackerModCat.isEnabled()) {
            this.allowsBlockBulkCapture = false;
            this.allowsEntityBulkCapture = false;
            this.allowsBlockEventCreation = false;
            this.allowsEntityEventCreation = false;
            entityTrackerModCat.getBlockBulkCaptureMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> this.allowsBlockBulkCapture);
            entityTrackerModCat.getEntityBulkCaptureMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> this.allowsEntityBulkCapture);
            entityTrackerModCat.getBlockEventCreationMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> this.allowsBlockEventCreation);
            entityTrackerModCat.getEntityEventCreationMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> this.allowsEntityEventCreation);
        } else {
            this.allowsBlockBulkCapture = entityTrackerModCat.getBlockBulkCaptureMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> true);
            this.allowsEntityBulkCapture = entityTrackerModCat.getEntityBulkCaptureMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> true);
            this.allowsBlockEventCreation = entityTrackerModCat.getBlockEventCreationMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> true);
            this.allowsEntityEventCreation = entityTrackerModCat.getEntityEventCreationMap().computeIfAbsent(this.entityName.toLowerCase(Locale.ENGLISH), k -> true);
        }
        if (entityTrackerCat.autoPopulateData()) {
            trackerConfigAdapter.save();
        }
        try {
            String mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "damageEntity" : "func_70665_d";
            Class[] argTypes = new Class[]{DamageSource.class, Float.TYPE};
            Class<?> clazz = this.getClass().getMethod(mapping, argTypes).getDeclaringClass();
            if (!(clazz.equals(EntityLivingBase.class) || clazz.equals(EntityPlayer.class) || clazz.equals(EntityPlayerMP.class))) {
                this.isModdedDamageEntityMethod = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Class<? extends org.spongepowered.api.entity.Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("modid", this.modId).add("class", this.entityClass.getName());
    }

    public Timing getTimingsHandler() {
        if (this.timing == null) {
            this.timing = SpongeTimings.getEntityTiming(this);
        }
        return this.timing;
    }

    public boolean isKnown() {
        return true;
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }
}

