/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import org.spongepowered.api.entity.ai.task.builtin.creature.AttackLivingAITask;
import org.spongepowered.api.entity.living.Creature;

public final class SpongeAttackLivingAIBuilder
implements AttackLivingAITask.Builder {
    private double speed;
    private boolean longMemory;

    public SpongeAttackLivingAIBuilder() {
        this.reset();
    }

    @Override
    public AttackLivingAITask.Builder speed(double speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public AttackLivingAITask.Builder longMemory() {
        this.longMemory = true;
        return this;
    }

    @Override
    public AttackLivingAITask.Builder from(AttackLivingAITask value) {
        return this.speed(value.getSpeed()).longMemory();
    }

    @Override
    public AttackLivingAITask.Builder reset() {
        this.speed = 0.0;
        this.longMemory = false;
        return this;
    }

    @Override
    public AttackLivingAITask build(Creature owner) {
        Preconditions.checkNotNull(owner);
        return (AttackLivingAITask)new EntityAIAttackMelee((EntityCreature)owner, this.speed, this.longMemory);
    }
}

