/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.task.builtin.creature.AvoidEntityAITask;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.util.Functional;

public final class SpongeAvoidEntityAIBuilder
implements AvoidEntityAITask.Builder {
    Predicate<Entity> targetSelector;
    float searchDistance;
    double closeRangeSpeed;
    double farRangeSpeed;

    public SpongeAvoidEntityAIBuilder() {
        this.reset();
    }

    @Override
    public AvoidEntityAITask.Builder targetSelector(Predicate<Entity> predicate) {
        this.targetSelector = predicate;
        return this;
    }

    @Override
    public AvoidEntityAITask.Builder searchDistance(float distance) {
        this.searchDistance = distance;
        return this;
    }

    @Override
    public AvoidEntityAITask.Builder closeRangeSpeed(double speed) {
        this.closeRangeSpeed = speed;
        return this;
    }

    @Override
    public AvoidEntityAITask.Builder farRangeSpeed(double speed) {
        this.farRangeSpeed = speed;
        return this;
    }

    @Override
    public AvoidEntityAITask.Builder from(AvoidEntityAITask value) {
        return this.targetSelector(value.getTargetSelector()).searchDistance(value.getSearchDistance()).closeRangeSpeed(value.getCloseRangeSpeed()).farRangeSpeed(value.getFarRangeSpeed());
    }

    @Override
    public AvoidEntityAITask.Builder reset() {
        this.searchDistance = 1.0f;
        this.closeRangeSpeed = 1.0;
        this.farRangeSpeed = 1.0;
        return this;
    }

    @Override
    public AvoidEntityAITask build(Creature owner) {
        Preconditions.checkNotNull(owner);
        Preconditions.checkNotNull(this.targetSelector);
        return (AvoidEntityAITask)new EntityAIAvoidEntity((EntityCreature)owner, Entity.class, Functional.java8ToGuava(this.targetSelector), this.searchDistance, this.closeRangeSpeed, this.farRangeSpeed);
    }
}

