/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAISwimming;
import org.spongepowered.api.entity.ai.task.builtin.SwimmingAITask;
import org.spongepowered.api.entity.living.Agent;

public final class SpongeSwimmingAIBuilder
implements SwimmingAITask.Builder {
    float chance = 0.8f;

    public SpongeSwimmingAIBuilder() {
        this.reset();
    }

    @Override
    public SwimmingAITask.Builder swimChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public SwimmingAITask.Builder from(SwimmingAITask value) {
        return this.swimChance(value.getSwimChance());
    }

    @Override
    public SwimmingAITask.Builder reset() {
        this.chance = 0.8f;
        return this;
    }

    @Override
    public SwimmingAITask build(Agent owner) {
        Preconditions.checkNotNull(owner);
        SwimmingAITask task = (SwimmingAITask)new EntityAISwimming((EntityLiving)owner);
        task.setSwimChance(this.chance);
        return task;
    }
}

