/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIWander;
import org.spongepowered.api.entity.ai.task.builtin.creature.WanderAITask;
import org.spongepowered.api.entity.living.Creature;

public final class SpongeWanderAIBuilder
implements WanderAITask.Builder {
    private double speed;
    private int executionChance;

    public SpongeWanderAIBuilder() {
        this.reset();
    }

    @Override
    public WanderAITask.Builder speed(double speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public WanderAITask.Builder executionChance(int executionChance) {
        this.executionChance = executionChance;
        return this;
    }

    @Override
    public WanderAITask.Builder from(WanderAITask value) {
        return this.speed(value.getSpeed()).executionChance(value.getExecutionChance());
    }

    @Override
    public WanderAITask.Builder reset() {
        this.speed = 1.0;
        this.executionChance = 120;
        return this;
    }

    @Override
    public WanderAITask build(Creature owner) {
        Preconditions.checkNotNull(owner);
        return (WanderAITask)new EntityAIWander((EntityCreature)owner, this.speed, this.executionChance);
    }
}

