/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.target;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import org.spongepowered.api.entity.ai.task.builtin.creature.target.FindNearestAttackableTargetAITask;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.entity.ai.target.SpongeTargetAIBuilder;

public final class SpongeFindNearestAttackableTargetAIBuilder
extends SpongeTargetAIBuilder<FindNearestAttackableTargetAITask, FindNearestAttackableTargetAITask.Builder>
implements FindNearestAttackableTargetAITask.Builder {
    private Class<? extends Living> targetClass;
    private int chance;
    @Nullable
    private Predicate<? extends Living> predicate;

    public SpongeFindNearestAttackableTargetAIBuilder() {
        this.reset();
    }

    @Override
    public FindNearestAttackableTargetAITask.Builder target(Class<? extends Living> targetClass) {
        this.targetClass = targetClass;
        return this;
    }

    @Override
    public FindNearestAttackableTargetAITask.Builder chance(int chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public FindNearestAttackableTargetAITask.Builder filter(Predicate<? extends Living> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public FindNearestAttackableTargetAITask.Builder from(FindNearestAttackableTargetAITask value) {
        return this.target(value.getTargetClass()).chance(value.getChance()).filter(value.getFilter());
    }

    @Override
    public FindNearestAttackableTargetAITask.Builder reset() {
        this.checkSight = false;
        this.onlyNearby = false;
        this.searchDelay = 0;
        this.interruptTargetUnseenTicks = 0;
        this.targetClass = null;
        this.predicate = null;
        return this;
    }

    @Override
    public FindNearestAttackableTargetAITask build(Creature owner) {
        Preconditions.checkNotNull(owner);
        Preconditions.checkNotNull(this.targetClass);
        return (FindNearestAttackableTargetAITask)new EntityAINearestAttackableTarget((EntityCreature)owner, this.targetClass, this.chance, this.checkSight, this.onlyNearby, this.predicate == null ? Predicates.alwaysTrue() : Functional.java8ToGuava(this.predicate));
    }
}

