/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.entity.player.tab.SpongeTabList;

public final class SpongeTabListEntry
implements TabListEntry {
    private SpongeTabList list;
    private final GameProfile profile;
    @Nullable
    private Text displayName;
    private int latency;
    private GameMode gameMode;
    private boolean updateWithoutSend;

    public SpongeTabListEntry(TabList list, GameProfile profile, @Nullable Text displayName, int latency, GameMode gameMode) {
        Preconditions.checkState(list instanceof SpongeTabList, "list is not a SpongeTabList");
        this.list = (SpongeTabList)list;
        this.profile = Preconditions.checkNotNull(profile, "profile");
        this.displayName = displayName;
        this.latency = latency;
        this.gameMode = Preconditions.checkNotNull(gameMode, "game mode");
    }

    @Override
    public TabList getList() {
        return this.list;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public Optional<Text> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public TabListEntry setDisplayName(@Nullable Text displayName) {
        this.displayName = displayName;
        this.sendUpdate(SPacketPlayerListItem.Action.UPDATE_DISPLAY_NAME);
        return this;
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public TabListEntry setLatency(int latency) {
        this.latency = latency;
        this.sendUpdate(SPacketPlayerListItem.Action.UPDATE_LATENCY);
        return this;
    }

    @Override
    public GameMode getGameMode() {
        return this.gameMode;
    }

    @Override
    public TabListEntry setGameMode(GameMode gameMode) {
        this.gameMode = Preconditions.checkNotNull(gameMode, "game mode");
        this.sendUpdate(SPacketPlayerListItem.Action.UPDATE_GAME_MODE);
        return this;
    }

    private void sendUpdate(SPacketPlayerListItem.Action action) {
        if (this.updateWithoutSend) {
            this.updateWithoutSend = false;
            return;
        }
        this.list.sendUpdate(this, action);
    }

    public void updateWithoutSend() {
        this.updateWithoutSend = true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TabListEntry that = (TabListEntry)other;
        return Objects.equal(this.profile.getUniqueId(), that.getProfile().getUniqueId());
    }

    public int hashCode() {
        return Objects.hashCode(this.profile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("profile", this.profile).add("latency", this.latency).add("displayName", this.displayName).add("gameMode", this.gameMode).toString();
    }
}

