/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;

public final class TabListEntryBuilder
implements TabListEntry.Builder {
    @Nullable
    private TabList list;
    @Nullable
    private GameProfile profile;
    @Nullable
    private Text displayName;
    private int latency;
    @Nullable
    private GameMode gameMode;

    @Override
    public TabListEntry.Builder list(TabList list) {
        this.list = Preconditions.checkNotNull(list, "list");
        return this;
    }

    @Override
    public TabListEntry.Builder profile(GameProfile profile) {
        this.profile = Preconditions.checkNotNull(profile, "profile");
        return this;
    }

    @Override
    public TabListEntry.Builder displayName(@Nullable Text displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public TabListEntry.Builder latency(int latency) {
        this.latency = latency;
        return this;
    }

    @Override
    public TabListEntry.Builder gameMode(GameMode gameMode) {
        this.gameMode = Preconditions.checkNotNull(gameMode, "game mode");
        return this;
    }

    @Override
    public TabListEntry build() {
        Preconditions.checkState(this.list != null, "list must be set");
        Preconditions.checkState(this.profile != null, "profile must be set");
        Preconditions.checkState(this.gameMode != null, "game mode must be set");
        return new SpongeTabListEntry(this.list, this.profile, this.displayName, this.latency, this.gameMode);
    }

    @Override
    public TabListEntry.Builder from(TabListEntry value) {
        this.list = Preconditions.checkNotNull(value.getList(), "list");
        this.profile = Preconditions.checkNotNull(value.getProfile(), "profile");
        this.displayName = value.getDisplayName().orElse(null);
        this.latency = value.getLatency();
        this.gameMode = Preconditions.checkNotNull(value.getGameMode(), "game mode");
        return this;
    }

    @Override
    public TabListEntry.Builder reset() {
        this.list = null;
        this.profile = null;
        this.displayName = null;
        this.latency = 0;
        this.gameMode = null;
        return this;
    }
}

