/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.generator.GeneratorUtils;
import org.spongepowered.common.event.AnnotatedEventListener;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterFactory;
import org.spongepowered.common.event.gen.DefineableClassLoader;

public final class ClassEventListenerFactory
implements AnnotatedEventListener.Factory {
    private final AtomicInteger id = new AtomicInteger();
    private final DefineableClassLoader classLoader;
    private final LoadingCache<Method, Class<? extends AnnotatedEventListener>> cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build(new CacheLoader<Method, Class<? extends AnnotatedEventListener>>(){

        @Override
        public Class<? extends AnnotatedEventListener> load(Method method) throws Exception {
            return ClassEventListenerFactory.this.createClass(method);
        }
    });
    private FilterFactory filterFactory;
    private final String targetPackage;
    private static final String BASE_HANDLER = Type.getInternalName(AnnotatedEventListener.class);
    private static final String HANDLE_METHOD_DESCRIPTOR = '(' + Type.getDescriptor(Event.class) + ")V";
    private static final String FILTER_DESCRIPTOR = "(" + Type.getDescriptor(Event.class) + ")[Ljava/lang/Object;";

    public ClassEventListenerFactory(String targetPackage, FilterFactory factory, DefineableClassLoader classLoader) {
        Preconditions.checkNotNull(targetPackage, "targetPackage");
        Preconditions.checkArgument(!targetPackage.isEmpty(), "targetPackage cannot be empty");
        this.targetPackage = targetPackage + '.';
        this.filterFactory = Preconditions.checkNotNull(factory, "filterFactory");
        this.classLoader = Preconditions.checkNotNull(classLoader, "classLoader");
    }

    @Override
    public AnnotatedEventListener create(Object handle, Method method) throws Exception {
        return this.cache.get(method).getConstructor(method.getDeclaringClass()).newInstance(handle);
    }

    Class<? extends AnnotatedEventListener> createClass(Method method) throws Exception {
        Class<?> handle = method.getDeclaringClass();
        Class<?> eventClass = method.getParameterTypes()[0];
        String name = this.targetPackage + eventClass.getSimpleName() + "Listener_" + handle.getSimpleName() + '_' + method.getName() + this.id.incrementAndGet();
        Class<? extends EventFilter> filter = this.filterFactory.createFilter(method);
        if (filter == null && method.getParameterCount() != 1) {
            throw new IllegalStateException("Failed to generate EventFilter for non trivial filtering operation.");
        }
        if (filter != null) {
            filter.newInstance();
            return this.classLoader.defineClass(name, ClassEventListenerFactory.generateClass(name, handle, method, eventClass, filter));
        }
        return this.classLoader.defineClass(name, ClassEventListenerFactory.generateClass(name, handle, method, eventClass));
    }

    private static byte[] generateClass(String name, Class<?> handle, Method method, Class<?> eventClass, Class<? extends EventFilter> filter) {
        name = name.replace('.', '/');
        String handleName = Type.getInternalName(handle);
        String handleDescriptor = Type.getDescriptor(handle);
        String filterName = Type.getInternalName(filter);
        String eventDescriptor = "(";
        for (int i = 0; i < method.getParameterCount(); ++i) {
            eventDescriptor = eventDescriptor + Type.getDescriptor(method.getParameterTypes()[i]);
        }
        eventDescriptor = eventDescriptor + ")V";
        ClassWriter cw = new ClassWriter(3);
        cw.visit(50, 49, name, null, BASE_HANDLER, null);
        FieldVisitor fv = cw.visitField(10, "FILTER", "L" + filterName + ";", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, filterName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, filterName, "<init>", "()V", false);
        mv.visitFieldInsn(179, name, "FILTER", "L" + filterName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", '(' + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitFieldInsn(178, name, "FILTER", "L" + filterName + ";");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(EventFilter.class), "filter", FILTER_DESCRIPTOR, true);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label l2 = new Label();
        mv.visitJumpInsn(198, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        for (int i = 0; i < method.getParameterCount(); ++i) {
            mv.visitVarInsn(25, 2);
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            Type paramType = Type.getType(method.getParameterTypes()[i]);
            GeneratorUtils.visitUnboxingMethod(mv, paramType);
        }
        mv.visitMethodInsn(182, handleName, method.getName(), eventDescriptor, false);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateClass(String name, Class<?> handle, Method method, Class<?> eventClass) {
        name = name.replace('.', '/');
        String handleName = Type.getInternalName(handle);
        String handleDescriptor = Type.getDescriptor(handle);
        String eventName = Type.getInternalName(eventClass);
        ClassWriter cw = new ClassWriter(3);
        cw.visit(50, 49, name, null, BASE_HANDLER, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", '(' + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventName);
        mv.visitMethodInsn(182, handleName, method.getName(), "(L" + eventName + ";)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

