/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.mixin.core.server.MinecraftServerAccessor;
import org.spongepowered.common.util.ThreadUtil;

@Singleton
public final class SpongeCauseStackManager
implements CauseStackManager {
    private static final boolean DEBUG_CAUSE_FRAMES = Boolean.parseBoolean(System.getProperty("sponge.debugcauseframes", "false"));
    private static final String INITIAL_POOL_SIZE_PROPERTY = "sponge.cause.initialFramePoolSize";
    private static final String MAX_POOL_SIZE_PROPERTY = "sponge.cause.maxFramePoolSize";
    private static final int INITIAL_POOL_SIZE;
    private static final int MAX_POOL_SIZE;
    private final Deque<Object> cause = Queues.newArrayDeque();
    private final Deque<CauseStackFrameImpl> frames = Queues.newArrayDeque();
    private final Deque<CauseStackFrameImpl> framePool = new ArrayDeque<CauseStackFrameImpl>(MAX_POOL_SIZE);
    private Map<EventContextKey<?>, Object> ctx = Maps.newHashMap();
    private int min_depth = 0;
    private int[] duplicateCauses = new int[100];
    @Nullable
    private Cause cached_cause;
    @Nullable
    private EventContext cached_ctx;
    private AtomicBoolean pendingProviders = new AtomicBoolean(false);
    private Deque<PhaseContext<?>> phaseContextProviders = new ArrayDeque();

    @Inject
    private SpongeCauseStackManager() {
        for (int i = 0; i < INITIAL_POOL_SIZE; ++i) {
            this.framePool.push(new CauseStackFrameImpl());
        }
    }

    private void enforceMainThread() {
        if (Sponge.isServerAvailable() && !SpongeCauseStackManager.isPermittedThread()) {
            throw new IllegalStateException(String.format("CauseStackManager called from off main thread (current='%s', expected='%s')!", ThreadUtil.getDescription(Thread.currentThread()), ThreadUtil.getDescription(((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getServerThread())));
        }
        this.checkProviders();
    }

    private static boolean isPermittedThread() {
        return SpongeImplHooks.isMainThread() || Thread.currentThread().getName().equals("Server Shutdown Thread");
    }

    @Override
    public Cause getCurrentCause() {
        this.enforceMainThread();
        if (this.cached_cause == null || this.cached_ctx == null) {
            this.cached_cause = this.cause.isEmpty() ? Cause.of(this.getCurrentContext(), SpongeImpl.getGame()) : Cause.of(this.getCurrentContext(), this.cause);
        }
        return this.cached_cause;
    }

    private void checkProviders() {
        if (!this.pendingProviders.compareAndSet(true, false)) {
            return;
        }
        Iterator<PhaseContext<?>> iterator = this.phaseContextProviders.descendingIterator();
        while (iterator.hasNext()) {
            PhaseContext<?> tuple = iterator.next();
            CauseStackManager.StackFrame frame = this.pushCauseFrame();
            tuple.state.getFrameModifier().accept(frame, tuple);
        }
        this.phaseContextProviders.clear();
    }

    @Override
    public EventContext getCurrentContext() {
        this.enforceMainThread();
        if (this.cached_ctx == null) {
            this.cached_ctx = EventContext.of(this.ctx);
        }
        return this.cached_ctx;
    }

    @Override
    public CauseStackManager pushCause(Object obj) {
        this.enforceMainThread();
        Preconditions.checkNotNull(obj, "obj");
        this.cached_cause = null;
        if (this.cause.peek() == obj) {
            int dupedIndex = this.cause.size();
            if (this.duplicateCauses.length <= dupedIndex) {
                this.duplicateCauses = Arrays.copyOf(this.duplicateCauses, (int)((double)dupedIndex * 1.5));
            }
            this.duplicateCauses[dupedIndex] = this.duplicateCauses[dupedIndex] + 1;
            return this;
        }
        this.cause.push(obj);
        return this;
    }

    @Override
    public Object popCause() {
        this.enforceMainThread();
        int size = this.cause.size();
        int dupeCause = this.duplicateCauses[size];
        if (dupeCause > 0) {
            this.duplicateCauses[size] = dupeCause - 1;
            return Preconditions.checkNotNull(this.cause.peek());
        }
        if (size <= this.min_depth) {
            throw new IllegalStateException("Cause stack corruption, tried to pop more objects off than were pushed since last frame (Size was " + size + " but mid depth is " + this.min_depth + ")");
        }
        this.cached_cause = null;
        return this.cause.pop();
    }

    @Override
    public void popCauses(int n) {
        this.enforceMainThread();
        for (int i = 0; i < n; ++i) {
            this.popCause();
        }
    }

    @Override
    public Object peekCause() {
        this.enforceMainThread();
        return this.cause.peek();
    }

    @Override
    public CauseStackManager.StackFrame pushCauseFrame() {
        CauseStackFrameImpl frame;
        this.enforceMainThread();
        int size = this.cause.size();
        if (this.duplicateCauses.length <= size) {
            this.duplicateCauses = Arrays.copyOf(this.duplicateCauses, (int)((double)size * 1.5));
        }
        if (this.framePool.isEmpty()) {
            frame = new CauseStackFrameImpl().set(this.min_depth, this.duplicateCauses[size]);
        } else {
            frame = this.framePool.pop();
            frame.clear();
            frame.old_min_depth = this.min_depth;
            frame.lastCauseSize = this.duplicateCauses[size];
        }
        this.frames.push(frame);
        this.min_depth = size;
        if (DEBUG_CAUSE_FRAMES) {
            frame.stack_debug = new Exception();
        }
        return frame;
    }

    @Override
    public void popCauseFrame(CauseStackManager.StackFrame oldFrame) {
        this.enforceMainThread();
        Preconditions.checkNotNull(oldFrame, "oldFrame");
        CauseStackFrameImpl frame = this.frames.peek();
        if (frame != oldFrame) {
            int offset = -1;
            int i = 0;
            for (CauseStackFrameImpl f : this.frames) {
                if (f == oldFrame) {
                    offset = i;
                    break;
                }
                ++i;
            }
            if (!DEBUG_CAUSE_FRAMES && offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            PrettyPrinter printer = new PrettyPrinter(100).add("Cause Stack Frame Corruption!").centre().hr().add("Found %n frames left on the stack. Clearing them all.", offset + 1);
            if (!DEBUG_CAUSE_FRAMES) {
                printer.add().add("Please add -Dsponge.debugcauseframes=true to your startup flags to enable further debugging output.");
                SpongeImpl.getLogger().warn("  Add -Dsponge.debugcauseframes to your startup flags to enable further debugging output.");
            } else {
                printer.add().add("Attempting to pop frame:").add(frame.stack_debug).add().add("Frames being popped are:").add(((CauseStackFrameImpl)oldFrame).stack_debug);
            }
            while (offset >= 0) {
                CauseStackFrameImpl f;
                f = this.frames.peek();
                if (DEBUG_CAUSE_FRAMES && offset > 0) {
                    printer.add((Object)"   Stack frame in position %n :", offset);
                    printer.add(f.stack_debug);
                }
                this.popCauseFrame(f);
                --offset;
            }
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            if (offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            return;
        }
        this.frames.pop();
        for (Map.Entry<EventContextKey<?>, Object> entry : frame.getOriginalContextDelta().entrySet()) {
            this.cached_ctx = null;
            if (entry.getValue() == null) {
                this.ctx.remove(entry.getKey());
                continue;
            }
            this.ctx.put(entry.getKey(), entry.getValue());
        }
        while (this.cause.size() > this.min_depth) {
            int index = this.cause.size();
            if (this.duplicateCauses.length > index) {
                this.duplicateCauses[index] = 0;
            }
            this.cause.pop();
            this.cached_cause = null;
        }
        this.min_depth = frame.old_min_depth;
        int size = this.cause.size();
        if (this.duplicateCauses.length > size) {
            this.duplicateCauses[size] = frame.lastCauseSize;
        }
        if (this.framePool.size() < MAX_POOL_SIZE) {
            frame.clear();
            this.framePool.push(frame);
        }
    }

    @Override
    public <T> CauseStackManager addContext(EventContextKey<T> key, T value) {
        this.enforceMainThread();
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.cached_ctx = null;
        Object existing = this.ctx.put(key, value);
        if (!this.frames.isEmpty()) {
            this.frames.peek().storeOriginalContext(key, existing);
        }
        return this;
    }

    @Override
    public <T> Optional<T> getContext(EventContextKey<T> key) {
        this.enforceMainThread();
        Preconditions.checkNotNull(key, "key");
        return Optional.ofNullable(this.ctx.get(key));
    }

    @Override
    public <T> Optional<T> removeContext(EventContextKey<T> key) {
        this.enforceMainThread();
        Preconditions.checkNotNull(key, "key");
        this.cached_ctx = null;
        Object existing = this.ctx.remove(key);
        if (!this.frames.isEmpty()) {
            this.frames.peek().storeOriginalContext(key, existing);
        }
        return Optional.ofNullable(existing);
    }

    public int registerPhaseContextProvider(PhaseContext<?> context) {
        Preconditions.checkNotNull(context.state.getFrameModifier(), "Consumer");
        this.pendingProviders.compareAndSet(false, true);
        this.cached_cause = null;
        this.cached_ctx = null;
        this.phaseContextProviders.push(context);
        return this.phaseContextProviders.size();
    }

    public void popFrameMutator(PhaseContext<?> context) {
        PhaseContext<?> peek = this.phaseContextProviders.peek();
        if (peek == null) {
            return;
        }
        if (peek != context) {
            System.err.println("oops. corrupted phase context providers!");
        }
        this.phaseContextProviders.pop();
        if (this.phaseContextProviders.isEmpty()) {
            this.pendingProviders.compareAndSet(true, false);
        }
    }

    static {
        int initialPoolSize = 50;
        int maxPoolSize = 100;
        try {
            initialPoolSize = Integer.parseInt(System.getProperty(INITIAL_POOL_SIZE_PROPERTY, "50"));
        }
        catch (NumberFormatException ex) {
            SpongeImpl.getLogger().warn("{} must be an integer, was set to {}. Defaulting to 50.", (Object)INITIAL_POOL_SIZE_PROPERTY, (Object)System.getProperty(INITIAL_POOL_SIZE_PROPERTY));
        }
        try {
            maxPoolSize = Integer.parseInt(System.getProperty(MAX_POOL_SIZE_PROPERTY, "100"));
        }
        catch (NumberFormatException ex) {
            SpongeImpl.getLogger().warn("{} must be an integer, was set to {}. Defaulting to 100.", (Object)MAX_POOL_SIZE_PROPERTY, (Object)System.getProperty(MAX_POOL_SIZE_PROPERTY));
        }
        MAX_POOL_SIZE = Math.max(0, maxPoolSize);
        INITIAL_POOL_SIZE = Math.max(0, Math.min(MAX_POOL_SIZE, initialPoolSize));
    }

    public static class CauseStackFrameImpl
    implements CauseStackManager.StackFrame {
        private final Map<EventContextKey<?>, Object> stored_ctx_values = new HashMap();
        int old_min_depth;
        int lastCauseSize;
        private final Map<EventContextKey<?>, Object> storedContext = new HashMap();
        @Nullable
        Exception stack_debug = null;

        CauseStackFrameImpl() {
        }

        public void clear() {
            this.stored_ctx_values.clear();
            this.storedContext.clear();
            this.lastCauseSize = -1;
            this.old_min_depth = -1;
            this.stack_debug = null;
        }

        public CauseStackFrameImpl set(int old_depth, int size) {
            this.old_min_depth = old_depth;
            this.lastCauseSize = size;
            return this;
        }

        public boolean isStored(EventContextKey<?> key) {
            return this.stored_ctx_values != null && this.stored_ctx_values.containsKey(key);
        }

        public Set<Map.Entry<EventContextKey<?>, Object>> getStoredValues() {
            return this.stored_ctx_values.entrySet();
        }

        public boolean hasStoredValues() {
            return !this.stored_ctx_values.isEmpty();
        }

        public void store(EventContextKey<?> key, Object existing) {
            this.stored_ctx_values.put(key, existing);
        }

        void storeOriginalContext(EventContextKey<?> key, @Nullable Object object) {
            if (!this.storedContext.containsKey(key)) {
                this.storedContext.put(key, object);
            }
        }

        Map<EventContextKey<?>, Object> getOriginalContextDelta() {
            return this.storedContext;
        }

        @Override
        public Cause getCurrentCause() {
            return Sponge.getCauseStackManager().getCurrentCause();
        }

        @Override
        public EventContext getCurrentContext() {
            return Sponge.getCauseStackManager().getCurrentContext();
        }

        @Override
        public CauseStackManager.StackFrame pushCause(Object obj) {
            Sponge.getCauseStackManager().pushCause(obj);
            return this;
        }

        @Override
        public Object popCause() {
            return Sponge.getCauseStackManager().popCause();
        }

        @Override
        public <T> CauseStackManager.StackFrame addContext(EventContextKey<T> key, T value) {
            Sponge.getCauseStackManager().addContext(key, value);
            return this;
        }

        @Override
        public <T> Optional<T> removeContext(EventContextKey<T> key) {
            return Sponge.getCauseStackManager().removeContext(key);
        }

        @Override
        public void close() {
            Sponge.getCauseStackManager().popCauseFrame(this);
        }
    }
}

