/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.common.event.SpongeEventContextKeyBuilder;

public final class SpongeEventContextKey<T>
implements EventContextKey<T> {
    private final String id;
    private final Class<T> allowed;
    private final String name;

    SpongeEventContextKey(SpongeEventContextKeyBuilder<T> builder) {
        this.id = builder.id;
        this.allowed = builder.typeClass;
        this.name = builder.name;
    }

    public SpongeEventContextKey(String id, String name, Class<T> allowed) {
        this.id = Preconditions.checkNotNull(id, "Id");
        this.allowed = Preconditions.checkNotNull(allowed, "Allowed");
        this.name = Preconditions.checkNotNull(name, "Name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getAllowedType() {
        return this.allowed;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContextKey)) {
            return false;
        }
        return this.id.equals(((EventContextKey)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

