/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntityDamageSourceIndirect;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.common.mixin.core.util.DamageSourceAccessor;

public class SpongeIndirectEntityDamageSourceBuilder
extends AbstractDamageSourceBuilder<IndirectEntityDamageSource, IndirectEntityDamageSource.Builder>
implements IndirectEntityDamageSource.Builder {
    protected WeakReference<org.spongepowered.api.entity.Entity> reference = null;
    private WeakReference<org.spongepowered.api.entity.Entity> proxy = null;

    @Override
    public IndirectEntityDamageSource.Builder proxySource(org.spongepowered.api.entity.Entity projectile) {
        this.proxy = new WeakReference<org.spongepowered.api.entity.Entity>(projectile);
        return this;
    }

    @Override
    public IndirectEntityDamageSource.Builder entity(org.spongepowered.api.entity.Entity entity) {
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(entity);
        return this;
    }

    @Override
    public IndirectEntityDamageSource build() throws IllegalStateException {
        Preconditions.checkState(this.reference.get() != null);
        Preconditions.checkState(this.proxy.get() != null);
        Preconditions.checkState(this.damageType != null);
        EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect(this.damageType.getId(), (Entity)this.reference.get(), (Entity)this.proxy.get());
        DamageSourceAccessor accessor = (DamageSourceAccessor)damageSource;
        if (this.creative) {
            accessor.accessor$setDamageAllowedInCreativeMode();
        }
        if (this.scales) {
            damageSource.func_76351_m();
        }
        if (this.magical) {
            damageSource.func_82726_p();
        }
        if (this.bypasses) {
            accessor.accessor$setDamageBypassesArmor();
        }
        if (this.absolute) {
            accessor.accessor$setDamageIsAbsolute();
        }
        if (this.explosion) {
            damageSource.func_94540_d();
        }
        if (this.exhaustion != null) {
            accessor.accessor$setHungerDamage(this.exhaustion.floatValue());
        }
        return (IndirectEntityDamageSource)damageSource;
    }

    @Override
    public IndirectEntityDamageSource.Builder from(IndirectEntityDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(value.getSource());
        this.proxy = new WeakReference<org.spongepowered.api.entity.Entity>(value.getIndirectSource());
        return this;
    }

    @Override
    public IndirectEntityDamageSource.Builder reset() {
        super.reset();
        this.reference = null;
        this.proxy = null;
        return this;
    }
}

