/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.MultiBlockCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;

public final class UnwindingPhaseContext
extends PhaseContext<UnwindingPhaseContext> {
    private final IPhaseState<?> unwindingState;
    private final PhaseContext<?> unwindingContext;
    @Nullable
    Deque<MultiBlockCaptureSupplier> blockSuppliers;
    @Nullable
    private Deque<SpongeBlockSnapshot> singleSnapshots;
    final boolean usesMulti;
    final boolean tracksNeighborNotifications;
    private final boolean isPostingSpecial;
    private boolean hasGotten = true;
    final boolean tracksTiles;

    @Override
    public boolean hasCaptures() {
        return super.hasCaptures() || this.usesMulti && this.blockSuppliers != null && !this.blockSuppliers.isEmpty();
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Nullable
    static UnwindingPhaseContext unwind(IPhaseState<?> state, PhaseContext<?> context, boolean hasCaptures) {
        if (!state.requiresPost() || !hasCaptures) {
            return null;
        }
        return (UnwindingPhaseContext)((UnwindingPhaseContext)((UnwindingPhaseContext)((UnwindingPhaseContext)new UnwindingPhaseContext(state, context).source(context.getSource())).addCaptures()).addEntityDropCaptures()).buildAndSwitch();
    }

    private UnwindingPhaseContext(IPhaseState<?> unwindingState, PhaseContext<?> unwindingContext) {
        super(GeneralPhase.Post.UNWINDING);
        this.unwindingState = unwindingState;
        this.unwindingContext = unwindingContext;
        this.tracksTiles = unwindingState.tracksTileEntityChanges(unwindingContext);
        this.tracksNeighborNotifications = unwindingState.doesCaptureNeighborNotifications(unwindingContext);
        this.isPostingSpecial = unwindingState.hasSpecificBlockProcess(unwindingContext);
        this.setBulkBlockCaptures(unwindingState.doesBulkBlockCapture(unwindingContext));
        boolean bl2 = this.usesMulti = this.allowsBulkBlockCaptures() && !this.isPostingSpecial;
        if (this.usesMulti) {
            this.blockSuppliers = new ArrayDeque<MultiBlockCaptureSupplier>(8);
            this.blockSuppliers.push(new MultiBlockCaptureSupplier());
        }
    }

    @Override
    public Optional<User> getOwner() {
        return this.unwindingContext.getOwner();
    }

    @Override
    public Optional<User> getNotifier() {
        return this.unwindingContext.getNotifier();
    }

    public <T extends PhaseContext<T>> T getUnwindingContext() {
        return (T)this.unwindingContext;
    }

    IPhaseState<?> getUnwindingState() {
        return this.unwindingState;
    }

    boolean isPostingSpecialProcess() {
        return this.isPostingSpecial;
    }

    void pushNewCaptureSupplier() {
        if (!this.usesMulti) {
            throw new IllegalStateException("This post state is not meant to capture multiple changes with neighbor notifications or tile entity changes!");
        }
        this.hasGotten = false;
    }

    void popBlockSupplier() {
        if (!this.usesMulti) {
            throw new IllegalStateException("This post state is not meant to capture multiple changes with neighbor notifications or tile entity changes!");
        }
        this.blockSuppliers.pop();
    }

    @Override
    public SpongeBlockSnapshot getSingleSnapshot() {
        if (this.singleSnapshot == null) {
            if (this.singleSnapshots == null) {
                throw new IllegalStateException("Expected to be capturing single snapshots for immediate throwing, but we're not finding any!");
            }
            return this.singleSnapshots.pop();
        }
        return this.singleSnapshot;
    }

    @Override
    public void setSingleSnapshot(@Nullable SpongeBlockSnapshot singleSnapshot) {
        if (singleSnapshot == null) {
            if (this.singleSnapshots != null && !this.singleSnapshots.isEmpty()) {
                this.singleSnapshots.pop();
            } else {
                this.singleSnapshot = null;
            }
        }
        if (this.singleSnapshot != null) {
            if (this.singleSnapshots == null) {
                this.singleSnapshots = new ArrayDeque<SpongeBlockSnapshot>();
            }
            this.singleSnapshots.push(this.singleSnapshot);
            this.singleSnapshot = null;
            this.singleSnapshots.push(singleSnapshot);
        } else if (this.singleSnapshots != null) {
            this.singleSnapshots.push(singleSnapshot);
        } else {
            this.singleSnapshot = singleSnapshot;
        }
    }

    @Override
    public MultiBlockCaptureSupplier getCapturedBlockSupplier() throws IllegalStateException {
        if (!this.usesMulti) {
            return super.getCapturedBlockSupplier();
        }
        if (!this.hasGotten) {
            MultiBlockCaptureSupplier peek = this.blockSuppliers.peek();
            this.blockSuppliers.push(new MultiBlockCaptureSupplier());
            this.hasGotten = true;
            return peek;
        }
        return this.blockSuppliers.peek();
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "UnwindingState", this.unwindingState).add(s + "- %s: %s", "UnwindingContext", this.unwindingContext).add(s + "- %s: %s", "IsPostingSpecial", this.tracksTiles);
        this.unwindingContext.printCustom(printer, indent * 2);
        return printer;
    }
}

