/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.Entity;

public class ItemDropData {
    final ItemStack stack;
    final Vector3d position;
    final double pitch;
    final double yaw;
    final Vector3d motion;

    public static Builder item(ItemStack stack) {
        return new Builder(stack);
    }

    ItemDropData(Builder builder) {
        this.stack = builder.stack;
        this.position = builder.position;
        this.pitch = builder.pitch;
        this.yaw = builder.yaw;
        this.motion = builder.motion;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public Vector3d getMotion() {
        return this.motion;
    }

    public EntityItem create(WorldServer worldServer) {
        EntityItem entityItem = new EntityItem((World)worldServer, this.position.getX(), this.position.getY(), this.position.getZ(), this.stack);
        if (this.motion != Vector3d.ZERO) {
            entityItem.field_70159_w = this.motion.getX();
            entityItem.field_70181_x = this.motion.getY();
            entityItem.field_70179_y = this.motion.getZ();
        }
        return entityItem;
    }

    public int hashCode() {
        return Objects.hashCode(this.stack, this.position, this.pitch, this.yaw, this.motion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemDropData other = (ItemDropData)obj;
        return Objects.equal(this.stack, other.stack) && Objects.equal(this.position, other.position) && Objects.equal(this.pitch, other.pitch) && Objects.equal(this.yaw, other.yaw) && Objects.equal(this.motion, other.motion);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("stack", this.stack).add("position", this.position).add("pitch", this.pitch).add("yaw", this.yaw).add("motion", this.motion).toString();
    }

    public static final class Player
    extends ItemDropData {
        private final boolean trace;
        private final String playerName;
        private final boolean dropAround;
        private final Random random;

        public static Builder player(EntityPlayer player) {
            return new Builder(player);
        }

        Player(Builder builder) {
            super(builder);
            this.trace = builder.trace;
            this.playerName = builder.playerName;
            this.dropAround = builder.dropAround;
            this.random = builder.random;
        }

        public boolean isTrace() {
            return this.trace;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public boolean isDropAround() {
            return this.dropAround;
        }

        public Random getRandom() {
            return this.random;
        }

        @Override
        public EntityItem create(WorldServer worldServer) {
            EntityItem entityItem = super.create(worldServer);
            entityItem.func_174867_a(40);
            if (this.trace) {
                entityItem.func_145799_b(this.playerName);
            }
            return entityItem;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Player player = (Player)o;
            return this.trace == player.trace && this.dropAround == player.dropAround && Objects.equal(this.playerName, player.playerName) && Objects.equal(this.random, player.random);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(super.hashCode(), this.trace, this.playerName, this.dropAround, this.random);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("trace", this.trace).add("playerName", this.playerName).add("dropAround", this.dropAround).add("random", this.random).add("stack", this.stack).add("position", this.position).add("pitch", this.pitch).add("yaw", this.yaw).add("motion", this.motion).toString();
        }

        public static final class Builder
        extends org.spongepowered.common.event.tracking.context.ItemDropData$Builder {
            boolean trace;
            String playerName;
            boolean dropAround;
            Random random;

            Builder(EntityPlayer player) {
                this.playerName = player.func_70005_c_();
                this.random = ((Entity)player).getRandom();
            }

            public Builder stack(ItemStack stack) {
                this.stack = stack;
                return this;
            }

            public Builder trace(boolean trace) {
                this.trace = trace;
                return this;
            }

            public Builder dropAround(boolean dropAround) {
                this.dropAround = dropAround;
                return this;
            }

            @Override
            public Builder position(Vector3d position) {
                super.position(position);
                return this;
            }

            @Override
            public Builder pitch(double pitch) {
                super.pitch(pitch);
                return this;
            }

            @Override
            public Builder yaw(double yaw) {
                super.yaw(yaw);
                return this;
            }

            @Override
            public Builder motion(Vector3d motion) {
                super.motion(motion);
                return this;
            }

            @Override
            public Player build() {
                return new Player(this);
            }
        }
    }

    public static class Builder {
        ItemStack stack;
        Vector3d position;
        double pitch;
        double yaw;
        Vector3d motion;

        Builder() {
        }

        Builder(ItemStack itemStack) {
            this.stack = itemStack;
        }

        public Builder position(Vector3d position) {
            this.position = position;
            return this;
        }

        public Builder pitch(double pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder yaw(double yaw) {
            this.yaw = yaw;
            return this;
        }

        public Builder motion(Vector3d motion) {
            this.motion = motion;
            return this;
        }

        public ItemDropData build() {
            if (this.motion == null) {
                this.motion = Vector3d.ZERO;
            }
            Preconditions.checkNotNull(this.stack, "ItemStack cannot be null!");
            Preconditions.checkNotNull(this.position, "Position cannot be null!");
            return new ItemDropData(this);
        }
    }
}

