/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.BlockTransaction;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;
import org.spongepowered.common.event.tracking.context.SpongeProxyBlockAccess;
import org.spongepowered.common.mixin.core.world.WorldServerAccessor;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class MultiBlockCaptureSupplier
implements ICaptureSupplier {
    public static final boolean PRINT_TRANSACTIONS = Boolean.parseBoolean(System.getProperty("sponge.debugBlockTransactions", "false"));
    @Nullable
    private LinkedListMultimap<BlockPos, SpongeBlockSnapshot> multimap;
    @Nullable
    private ListMultimap<BlockPos, BlockEventData> scheduledEvents;
    @Nullable
    private List<SpongeBlockSnapshot> snapshots;
    @Nullable
    private LinkedHashMap<WorldServer, SpongeProxyBlockAccess.Proxy> processingWorlds;
    @Nullable
    private Set<BlockPos> usedBlocks;
    private int transactionIndex = -1;
    private int snapshotIndex = -1;
    @Nullable
    private BlockTransaction tail;
    @Nullable
    private BlockTransaction head;

    public boolean put(BlockSnapshot snapshot, IBlockState newState) {
        SpongeBlockSnapshot backingSnapshot = this.getBackingSnapshot(snapshot);
        BlockPos blockPos = backingSnapshot.getBlockPos();
        if (this.usedBlocks == null) {
            this.usedBlocks = new HashSet<BlockPos>();
            this.usedBlocks.add(blockPos);
            this.addSnapshot(backingSnapshot);
            return true;
        }
        boolean added = this.usedBlocks.add(blockPos);
        if (this.multimap != null) {
            if (added) {
                this.addSnapshot(backingSnapshot);
            }
            this.multimap.put(blockPos, backingSnapshot);
            if (!added) {
                this.associateBlockChangeForPosition(newState, blockPos);
            }
            return added;
        }
        if (!added) {
            this.multimap = LinkedListMultimap.create();
            for (SpongeBlockSnapshot existing : this.snapshots) {
                this.multimap.put(existing.getBlockPos(), existing);
            }
            this.multimap.put(blockPos, backingSnapshot);
            this.associateBlockChangeForPosition(newState, blockPos);
            return false;
        }
        this.addSnapshot(backingSnapshot);
        return true;
    }

    private void addSnapshot(SpongeBlockSnapshot backingSnapshot) {
        if (this.snapshots == null) {
            this.snapshots = new ArrayList<SpongeBlockSnapshot>();
        }
        this.snapshots.add(backingSnapshot);
        ++this.snapshotIndex;
    }

    private void associateBlockChangeForPosition(IBlockState newState, BlockPos blockPos) {
        Collection list = this.multimap.get((Object)blockPos);
        if (list != null && !list.isEmpty()) {
            SpongeBlockSnapshot originalSnapshot = (SpongeBlockSnapshot)list.get(0);
            PhaseContext<?> peek = PhaseTracker.getInstance().getCurrentContext();
            IBlockState currentState = (IBlockState)originalSnapshot.getState();
            originalSnapshot.blockChange = peek.state.associateBlockChangeWithSnapshot(peek, newState, newState.func_177230_c(), currentState, originalSnapshot, currentState.func_177230_c());
        }
    }

    public final List<SpongeBlockSnapshot> get() {
        return this.snapshots == null ? Collections.emptyList() : Collections.unmodifiableList(this.snapshots);
    }

    public final void prune(BlockSnapshot snapshot) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Unexpected pruning on an empty capture object for position " + snapshot.getPosition());
        }
        SpongeBlockSnapshot backingSnapshot = this.getBackingSnapshot(snapshot);
        BlockPos blockPos = backingSnapshot.getBlockPos();
        if (this.multimap != null) {
            this.pruneFromMulti(backingSnapshot, blockPos);
            return;
        }
        this.pruneSingle(backingSnapshot, blockPos);
        if (this.head != null) {
            this.pruneTransaction(this.getBackingSnapshot(snapshot));
        }
    }

    private void pruneSingle(SpongeBlockSnapshot backingSnapshot, BlockPos blockPos) {
        if (this.usedBlocks == null) {
            throw new IllegalStateException("Expected to remove a single block change that was supposed to be captured....");
        }
        if (this.snapshots == null) {
            throw new IllegalStateException("Expected to remove a single block change that was supposed to be captured....");
        }
        this.usedBlocks.remove(blockPos);
        this.snapshots.remove(backingSnapshot);
    }

    private void pruneFromMulti(SpongeBlockSnapshot backingSnapshot, BlockPos blockPos) {
        Collection snapshots = this.multimap.get((Object)blockPos);
        if (snapshots != null) {
            SpongeBlockSnapshot next;
            Iterator iterator = snapshots.iterator();
            while (iterator.hasNext()) {
                next = (SpongeBlockSnapshot)iterator.next();
                if (!next.getState().equals(backingSnapshot.getState())) continue;
                iterator.remove();
                break;
            }
            if (snapshots.isEmpty()) {
                this.multimap.removeAll(blockPos);
                Iterator<SpongeBlockSnapshot> firsts = this.snapshots.iterator();
                while (firsts.hasNext()) {
                    next = firsts.next();
                    if (!next.equals(backingSnapshot)) continue;
                    firsts.remove();
                    this.usedBlocks.remove(blockPos);
                    break;
                }
                if (this.snapshots.isEmpty()) {
                    this.multimap = null;
                }
            }
        }
    }

    private SpongeBlockSnapshot getBackingSnapshot(BlockSnapshot snapshot) {
        SpongeBlockSnapshot backingSnapshot = !(snapshot instanceof SpongeBlockSnapshot) ? SpongeBlockSnapshotBuilder.pooled().from(snapshot).build() : (SpongeBlockSnapshot)snapshot;
        return backingSnapshot;
    }

    @Override
    public final boolean isEmpty() {
        return (this.snapshots == null || this.snapshots.isEmpty()) && this.head == null;
    }

    public final void acceptAndClearIfNotEmpty(BiConsumer<List<? extends BlockSnapshot>, Map<BlockPos, List<BlockSnapshot>>> consumer) {
        if (this.multimap != null) {
            List<SpongeBlockSnapshot> blockSnapshots = this.get();
            Map<BlockPos, List<SpongeBlockSnapshot>> view = Multimaps.asMap(this.multimap);
            LinkedHashMap map = new LinkedHashMap(view.size());
            for (Map.Entry<BlockPos, List<SpongeBlockSnapshot>> entryView : view.entrySet()) {
                map.put(entryView.getKey(), new ArrayList(entryView.getValue()));
            }
            this.multimap.clear();
            consumer.accept(blockSnapshots, map);
        }
    }

    private void logTransaction(BlockTransaction transaction) {
        if (this.tail != null) {
            this.tail.next = transaction;
        } else {
            this.head = transaction;
        }
        transaction.previous = this.tail;
        this.tail = transaction;
    }

    private void pruneTransaction(SpongeBlockSnapshot snapshot) {
        if (this.head == null) {
            return;
        }
        BlockTransaction transaction = this.head;
        while (transaction != null) {
            if (transaction.equalsSnapshot(snapshot)) {
                BlockTransaction previous = transaction.previous;
                BlockTransaction next = transaction.next;
                if (previous == null) {
                    this.head = next;
                } else {
                    previous.next = next;
                    transaction.previous = null;
                }
                if (next == null) {
                    this.tail = previous;
                } else {
                    next.previous = previous;
                    transaction.next = null;
                }
            }
            transaction = transaction.next;
        }
    }

    public void captureNeighborNotification(WorldServerBridge mixinWorldServer, IBlockState notifyState, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos) {
        int transactionIndex = ++this.transactionIndex;
        IBlockState actualSourceState = ((WorldServer)mixinWorldServer).func_180495_p(sourcePos);
        BlockTransaction.NeighborNotification notification = new BlockTransaction.NeighborNotification(transactionIndex, this.snapshotIndex, mixinWorldServer, notifyState, notifyPos, sourceBlock, sourcePos, actualSourceState);
        notification.enqueueChanges(mixinWorldServer.bridge$getProxyAccess(), this);
        this.logTransaction(notification);
    }

    public BlockTransaction.ChangeBlock logBlockChange(SpongeBlockSnapshot originalBlockSnapshot, IBlockState newState, BlockChangeFlag flags) {
        this.put(originalBlockSnapshot, newState);
        int transactionIndex = ++this.transactionIndex;
        BlockTransaction.ChangeBlock changeBlock = new BlockTransaction.ChangeBlock(transactionIndex, this.snapshotIndex, originalBlockSnapshot, newState, (SpongeBlockChangeFlag)flags);
        this.logTransaction(changeBlock);
        return changeBlock;
    }

    public void logTileChange(WorldServerBridge mixinWorldServer, BlockPos pos, @Nullable TileEntity oldTile, @Nullable TileEntity newTile) {
        BlockTransaction transaction;
        SpongeBlockSnapshot snapshot;
        WorldServer world = (WorldServer)mixinWorldServer;
        IBlockState current = world.func_180495_p(pos);
        if (this.tail instanceof BlockTransaction.ChangeBlock) {
            BlockTransaction.ChangeBlock changeBlock = (BlockTransaction.ChangeBlock)this.tail;
            if (oldTile != null && newTile == null && changeBlock.queueBreak) {
                if (changeBlock.queuedRemoval == oldTile) {
                    return;
                }
                changeBlock.queuedRemoval = oldTile;
                if (changeBlock.queueTileSet == null) {
                    mixinWorldServer.bridge$getProxyAccess().queueRemoval(oldTile);
                } else {
                    changeBlock.queueTileSet.func_174878_a(pos);
                    mixinWorldServer.bridge$getProxyAccess().queueReplacement(changeBlock.queueTileSet, changeBlock.queuedRemoval);
                    mixinWorldServer.bridge$getProxyAccess().unmarkRemoval(pos, oldTile);
                }
                return;
            }
        }
        if (newTile != null && this.tail != null) {
            boolean isSame = false;
            BlockTransaction prevChange = this.tail;
            while (prevChange != null) {
                if (prevChange instanceof BlockTransaction.ChangeBlock) {
                    BlockTransaction.ChangeBlock changeBlock = (BlockTransaction.ChangeBlock)prevChange;
                    boolean bl2 = isSame = changeBlock.queuedRemoval == newTile;
                    if (isSame) {
                        changeBlock.ignoreBreakBlockLogic = true;
                        changeBlock.queuedRemoval = null;
                        ((TileEntityBridge)newTile).bridge$setCaptured(false);
                        break;
                    }
                }
                prevChange = prevChange.previous;
            }
            if (isSame) {
                if (mixinWorldServer.bridge$getProxyAccess().isTileQueuedForRemoval(pos, newTile)) {
                    mixinWorldServer.bridge$getProxyAccess().unmarkRemoval(pos, newTile);
                }
                return;
            }
        }
        int transactionIndex = ++this.transactionIndex;
        if (oldTile != null) {
            snapshot = mixinWorldServer.bridge$createSnapshotWithEntity(current, pos, BlockChangeFlags.NONE, oldTile);
            this.put(snapshot, current);
            if (newTile != null) {
                snapshot.blockChange = BlockChange.MODIFY;
                transaction = new BlockTransaction.ReplaceTileEntity(transactionIndex, this.snapshotIndex, newTile, oldTile, snapshot);
                this.logTransaction(transaction);
                ((BlockTransaction.ReplaceTileEntity)transaction).enqueueChanges(mixinWorldServer.bridge$getProxyAccess(), this);
                return;
            }
            snapshot.blockChange = BlockChange.BREAK;
            transaction = new BlockTransaction.RemoveTileEntity(transactionIndex, this.snapshotIndex, oldTile, snapshot);
            ((BlockTransaction.RemoveTileEntity)transaction).enqueueChanges(mixinWorldServer.bridge$getProxyAccess(), this);
            this.logTransaction(transaction);
            return;
        }
        if (newTile != null) {
            snapshot = mixinWorldServer.bridge$createSnapshotWithEntity(current, pos, BlockChangeFlags.NONE, newTile);
            snapshot.blockChange = BlockChange.PLACE;
            transaction = new BlockTransaction.AddTileEntity(transactionIndex, this.snapshotIndex, newTile, snapshot);
            ((BlockTransaction.AddTileEntity)transaction).enqueueChanges(mixinWorldServer.bridge$getProxyAccess(), this);
            this.logTransaction(transaction);
        }
    }

    void queuePreviousStates(BlockTransaction transaction) {
        if (this.head != null) {
            if (transaction == this.head) {
                return;
            }
            BlockTransaction prevChange = this.head;
            while (prevChange != null) {
                if (transaction.appliedPreChange) {
                    return;
                }
                transaction.provideUnchangedStates(prevChange);
                prevChange = prevChange.next;
            }
        }
    }

    public void cancelTransaction(BlockSnapshot original) {
        if (this.tail == null) {
            return;
        }
        SpongeBlockSnapshot snapshot = (SpongeBlockSnapshot)original;
        BlockPos blockPos = snapshot.getBlockPos();
        snapshot.getWorldServer().ifPresent(worldServer -> {
            BlockTransaction prevChange = this.tail;
            while (prevChange != null) {
                if (!prevChange.isCancelled) {
                    prevChange.cancel((WorldServer)worldServer, blockPos, ((WorldServerBridge)worldServer).bridge$getProxyAccess());
                }
                prevChange = prevChange.previous;
            }
        });
    }

    public void clear() {
        if (this.multimap != null) {
            this.multimap.clear();
            this.multimap = null;
        }
        if (this.snapshots != null) {
            this.snapshots.clear();
            this.snapshots = null;
        }
        if (this.usedBlocks != null) {
            this.usedBlocks.clear();
        }
        if (this.scheduledEvents != null) {
            this.scheduledEvents.clear();
        }
        this.snapshotIndex = -1;
        this.transactionIndex = -1;
    }

    public void restoreOriginals() {
        if (this.snapshots != null && !this.snapshots.isEmpty()) {
            for (SpongeBlockSnapshot original : Lists.reverse(this.snapshots)) {
                original.restore(true, BlockChangeFlags.NONE);
            }
            this.clear();
        }
    }

    public Optional<Transaction<BlockSnapshot>> createTransaction(SpongeBlockSnapshot snapshot) {
        Collection intermediary;
        Optional<WorldServer> maybeWorld = snapshot.getWorldServer();
        if (!maybeWorld.isPresent()) {
            return Optional.empty();
        }
        WorldServer worldServer = maybeWorld.get();
        BlockPos blockPos = snapshot.getBlockPos();
        IBlockState newState = worldServer.func_180495_p(blockPos);
        IBlockState newActualState = this.head != null ? newState : newState.func_185899_b((IBlockAccess)worldServer, blockPos);
        SpongeBlockSnapshot newSnapshot = ((WorldServerBridge)worldServer).bridge$createSnapshot(newState, newActualState, blockPos, BlockChangeFlags.NONE);
        if (this.multimap != null && !(intermediary = this.multimap.get((Object)blockPos)).isEmpty() && intermediary.size() > 1) {
            ImmutableList.Builder builder = ImmutableList.builder();
            boolean movedPastFirst = false;
            Iterator iterator = intermediary.iterator();
            while (iterator.hasNext()) {
                if (!movedPastFirst) {
                    iterator.next();
                    movedPastFirst = true;
                    continue;
                }
                builder.add(iterator.next());
            }
            return Optional.of(new Transaction<SpongeBlockSnapshot>(snapshot, newSnapshot, (List<SpongeBlockSnapshot>)((Object)builder.build())));
        }
        return Optional.of(new Transaction<SpongeBlockSnapshot>(snapshot, newSnapshot));
    }

    public boolean trackEvent(BlockPos pos, BlockEventData blockEventData) {
        if (this.usedBlocks != null && this.usedBlocks.contains(pos)) {
            if (this.scheduledEvents == null) {
                this.scheduledEvents = LinkedListMultimap.create();
            }
            this.scheduledEvents.put(pos.func_185334_h(), blockEventData);
            return true;
        }
        return false;
    }

    public ListMultimap<BlockPos, BlockEventData> getScheduledEvents() {
        return this.scheduledEvents == null || this.scheduledEvents.isEmpty() ? ImmutableListMultimap.of() : ArrayListMultimap.create(this.scheduledEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTransactions(List<Transaction<BlockSnapshot>> transactions, PhaseContext<?> phaseContext, boolean noCancelledTransactions, ListMultimap<BlockPos, BlockEventData> scheduledEvents, int currentDepth) {
        IPhaseState phaseState = phaseContext.state;
        int targetIndex = 0;
        if (this.tail == null) {
            boolean hasEvents = false;
            if (!scheduledEvents.isEmpty()) {
                hasEvents = true;
            }
            for (Transaction<BlockSnapshot> transaction : transactions) {
                if (!transaction.isValid()) continue;
                TrackingUtil.performTransactionProcess(transaction, phaseContext, currentDepth);
                if (!hasEvents) continue;
                SpongeBlockSnapshot original = (SpongeBlockSnapshot)transaction.getOriginal();
                original.getWorldServer().ifPresent(worldServer -> {
                    WorldServerAccessor accessor = (WorldServerAccessor)worldServer;
                    WorldServer.ServerBlockEventList queue = accessor.getBlockEventQueueForSponge()[accessor.getBlockEventCacheIndexForSponge()];
                    for (BlockEventData blockEventData : scheduledEvents.get((Object)original.getBlockPos())) {
                        boolean equals = false;
                        for (BlockEventData eventData : queue) {
                            if (!eventData.equals((Object)blockEventData)) continue;
                            equals = true;
                            break;
                        }
                        if (equals) continue;
                        queue.add((Object)blockEventData);
                    }
                });
            }
            return noCancelledTransactions;
        }
        Transaction<BlockSnapshot> eventTransaction = transactions.isEmpty() ? null : transactions.get(targetIndex);
        try {
            BlockTransaction head = this.head;
            this.head = null;
            this.tail = null;
            BlockTransaction transaction = head;
            while (transaction != null) {
                if (transaction.snapshotIndex > targetIndex) {
                    eventTransaction = transactions.get(++targetIndex);
                }
                if (eventTransaction != null && !eventTransaction.isValid()) {
                    BlockTransaction next = transaction.next;
                    transaction.next = null;
                    transaction.previous = null;
                    transaction = next;
                    continue;
                }
                Optional<WorldServerBridge> maybeWorld = transaction.getWorldServer();
                BlockTransaction derp = transaction;
                try (SpongeProxyBlockAccess access2 = maybeWorld.map(WorldServerBridge::bridge$getProxyAccess).map(proxy -> proxy.switchTo(derp)).orElse(null);
                     SpongeProxyBlockAccess.Proxy ignored = maybeWorld.map(transaction::getProxy).orElse(null);){
                    PrettyPrinter printer = PRINT_TRANSACTIONS ? new PrettyPrinter(60).add("Debugging BlockTransaction").centre().hr().addWrapped(60, "This is a process printout of the information passed along from the Proxy and the world.", new Object[0]).add().add("Proxy Container:") : null;
                    if (transaction.blocksNotAffected != null) {
                        transaction.blocksNotAffected.forEach((pos, block) -> {
                            if (PRINT_TRANSACTIONS) {
                                printer.addWrapped(120, "  %s : %s, %s", "UnaffectedBlock", pos, block);
                            }
                            if (access2 != null) {
                                access2.proceed((BlockPos)pos, (IBlockState)block, false);
                            }
                        });
                    }
                    if (transaction.tilesAtTransaction != null) {
                        transaction.tilesAtTransaction.forEach((pos, tile) -> {
                            if (PRINT_TRANSACTIONS) {
                                printer.addWrapped(120, "  %s : %s, %s", "UnaffectedTile", pos, tile == null ? "null" : ((TileEntityBridge)tile).bridge$getPrettyPrinterString());
                            }
                            if (access2 != null) {
                                access2.pushTile((BlockPos)pos, (TileEntity)tile);
                            }
                        });
                    }
                    if (PRINT_TRANSACTIONS) {
                        if (access2 != null) {
                            access2.addToPrinter(printer);
                        }
                        transaction.addToPrinter(printer);
                        printer.print(System.err);
                    }
                    transaction.process(eventTransaction, phaseState, phaseContext, currentDepth);
                }
                catch (Exception e) {
                    PrettyPrinter printer = new PrettyPrinter(60).add("Exception while trying to apply transaction").centre().hr().addWrapped(60, "BlockTransactions failing to process can lead to unintended consequences. If the exception is *directly* coming from Sponge's code, please report to Sponge.", new Object[0]).add();
                    maybeWorld.map(WorldServerBridge::bridge$getProxyAccess).ifPresent(access -> access.addToPrinter(printer));
                    transaction.addToPrinter(printer);
                    printer.add();
                    printer.add("Exception: ").add(e).trace(System.err);
                }
                maybeWorld.map(WorldServerBridge::bridge$getProxyAccess).ifPresent(transaction::postProcessBlocksAffected);
                BlockTransaction next = transaction.next;
                transaction.next = null;
                transaction.previous = null;
                transaction = next;
            }
        }
        finally {
            this.clearProxies();
            this.resetTransactionLinks();
        }
        return noCancelledTransactions;
    }

    void getProxyOrCreate(WorldServerBridge mixinWorldServer) {
        SpongeProxyBlockAccess.Proxy existing;
        if (this.processingWorlds == null) {
            this.processingWorlds = new LinkedHashMap();
        }
        if ((existing = this.processingWorlds.get((WorldServer)mixinWorldServer)) == null) {
            existing = mixinWorldServer.bridge$getProxyAccess().pushProxy();
            this.processingWorlds.put((WorldServer)mixinWorldServer, existing);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.snapshots);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiBlockCaptureSupplier other = (MultiBlockCaptureSupplier)obj;
        return Objects.equals(this.multimap, other.multimap);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Captured", this.snapshots == null ? 0 : this.snapshots.size()).add("Head", this.head == null ? "null" : this.head).toString();
    }

    public void clearProxies() {
        if (this.processingWorlds == null || this.processingWorlds.isEmpty()) {
            return;
        }
        for (Map.Entry<WorldServer, SpongeProxyBlockAccess.Proxy> entry : this.processingWorlds.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                PhaseTracker.getInstance().printMessageWithCaughtException("Forcibly Closing Proxy", "Proxy Access could not be popped", e);
            }
        }
        this.processingWorlds.clear();
    }

    public boolean hasTransactions() {
        return this.head != null;
    }

    public boolean hasBlocksCaptured() {
        return this.snapshots != null && !this.snapshots.isEmpty();
    }

    public void reset() {
        if (this.multimap != null) {
            this.multimap = null;
        }
        if (this.scheduledEvents != null) {
            this.scheduledEvents = null;
        }
        if (this.snapshots != null) {
            this.snapshots = null;
        }
        if (this.usedBlocks != null) {
            this.usedBlocks = null;
        }
        this.clearProxies();
        this.transactionIndex = -1;
        this.snapshotIndex = -1;
        if (this.head != null) {
            this.resetTransactionLinks();
        }
    }

    private void resetTransactionLinks() {
        BlockTransaction transaction = this.head;
        while (transaction != null) {
            BlockTransaction next = transaction.next;
            transaction.previous = null;
            transaction.next = null;
            transaction = next;
        }
        this.head = null;
        this.tail = null;
    }
}

