/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.BlockTransaction;
import org.spongepowered.common.mixin.core.world.WorldAccessor;
import org.spongepowered.common.world.BlockChange;

public final class SpongeProxyBlockAccess
implements IBlockAccess,
AutoCloseable {
    private static final boolean DEBUG_PROXY = Boolean.valueOf(System.getProperty("sponge.debugProxyChanges", "false"));
    private final LinkedHashMap<BlockPos, IBlockState> processed = new LinkedHashMap();
    private final LinkedHashMap<BlockPos, TileEntity> affectedTileEntities = new LinkedHashMap();
    private final ListMultimap<BlockPos, TileEntity> queuedTiles = LinkedListMultimap.create();
    private final ListMultimap<BlockPos, TileEntity> queuedRemovals = LinkedListMultimap.create();
    private final Set<BlockPos> markedRemoved = new HashSet<BlockPos>();
    private final Deque<Proxy> proxies = Queues.newArrayDeque();
    private WorldServer processingWorld;
    @Nullable
    private BlockTransaction processingTransaction;
    @Nullable
    private Deque<BlockTransaction> processingStack;
    private boolean isNeighbor = false;
    private boolean hasTile = false;

    public SpongeProxyBlockAccess(WorldServerBridge worldServer) {
        this.processingWorld = (WorldServer)worldServer;
    }

    Proxy pushProxy() {
        Proxy proxy = new Proxy(this);
        this.proxies.push(proxy);
        if (DEBUG_PROXY) {
            proxy.stack_debug = new Exception();
        }
        return proxy;
    }

    SpongeProxyBlockAccess proceed(BlockPos pos, IBlockState state, boolean b2) {
        if (this.proxies.isEmpty()) {
            throw new IllegalStateException("Cannot push a new block change without having proxies!");
        }
        IBlockState existing = this.processed.put(pos, state);
        if (!this.proxies.isEmpty()) {
            Proxy proxy = this.proxies.peek();
            if (existing == null) {
                proxy.markNew(pos);
            } else if (!(this.processingTransaction == null && proxy.isStored(pos) || proxy.isNew(pos))) {
                proxy.store(pos, state);
            }
        }
        if (b2 && this.processingTransaction != null) {
            PhaseTracker.getInstance().setBlockState((WorldServerBridge)this.processingWorld, pos, state, BlockChangeFlags.NONE);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void popProxy(Proxy oldProxy) {
        if (oldProxy == null) {
            throw new IllegalArgumentException("Cannot pop a null proxy!");
        }
        Proxy proxy = this.proxies.peek();
        if (proxy != oldProxy) {
            int offset = -1;
            boolean bl2 = false;
            for (Proxy f : this.proxies) {
                void var4_6;
                if (f == oldProxy) {
                    offset = var4_6;
                    break;
                }
                ++var4_6;
            }
            if (!DEBUG_PROXY && offset == -1) {
                throw new IllegalStateException("Block Change Proxy corruption! Attempted to pop a proxy that was not on the stack.");
            }
            PrettyPrinter printer = new PrettyPrinter(100).add("Block Change Proxy Corruption!").centre().hr().add("Found %n proxies left on the stack. Clearing them all.", offset + 1);
            if (!DEBUG_PROXY) {
                printer.add().add("Please add -Dsponge.debugProxyChanges=true to your startup flags to enable further debugging output.");
                SpongeImpl.getLogger().warn("  Add -Dsponge.debugProxyChanges to your startup flags to enable further debugging output.");
            } else {
                printer.add().add("Attempting to pop proxy:").add(proxy.stack_debug).add().add("Frames being popped are:").add(oldProxy.stack_debug);
            }
            while (offset >= 0) {
                Proxy f;
                f = this.proxies.peek();
                if (DEBUG_PROXY && offset > 0) {
                    printer.add((Object)"   Stack proxy in position %n :", offset);
                    printer.add(f.stack_debug);
                }
                this.popProxy(f);
                --offset;
            }
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            if (offset == -1) {
                throw new IllegalStateException("Cause Stack Proxy Corruption! Attempted to pop a proxy that was not on the stack.");
            }
            return;
        }
        this.proxies.pop();
        if (proxy.hasNew()) {
            for (BlockPos blockPos : proxy.newBlocks) {
                this.processed.remove(blockPos);
            }
        }
        if (proxy.hasStored()) {
            if (!this.proxies.isEmpty()) {
                for (Map.Entry entry : proxy.processed.entrySet()) {
                    this.processed.put((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                }
            } else {
                for (BlockPos blockPos : proxy.processed.keySet()) {
                    this.processed.remove(blockPos);
                }
            }
        }
        if (proxy.hasRemovals()) {
            for (BlockPos blockPos : proxy.markedRemovedTiles) {
                this.markedRemoved.remove(blockPos);
            }
        }
        if (this.proxies.isEmpty()) {
            PrettyPrinter pretty = null;
            if (!this.processed.isEmpty()) {
                PrettyPrinter prettyPrinter = pretty = new PrettyPrinter(60).add("%s : %s", "Remaining", this.processed.size());
                this.processed.forEach((pos, state) -> printer.add("- %s : %s", "Pos", pos).addWrapped(60, "  %s : %s", "State", state));
                this.processed.clear();
            }
            if (!this.markedRemoved.isEmpty()) {
                if (pretty == null) {
                    pretty = new PrettyPrinter(60);
                }
                pretty.add("Unclaimed Removed Tile Positions");
                PrettyPrinter prettyPrinter = pretty;
                this.markedRemoved.forEach(pos -> printer.add("  -%s", pos));
                pretty.add();
                this.markedRemoved.clear();
            }
            if (!this.queuedTiles.isEmpty()) {
                if (pretty == null) {
                    pretty = new PrettyPrinter(60);
                }
                pretty.add("Unadded TileEntities queued for addition");
                PrettyPrinter prettyPrinter = pretty;
                this.queuedTiles.forEach((pos, tile) -> printer.add(" - %s : %s", pos, tile == null ? "null" : ((TileEntityBridge)tile).bridge$getPrettyPrinterString()));
                this.queuedTiles.clear();
            }
            if (!this.queuedRemovals.isEmpty()) {
                if (pretty == null) {
                    pretty = new PrettyPrinter(60);
                }
                pretty.add("Unremoved TileEntities queued for removal!");
                PrettyPrinter prettyPrinter = pretty;
                this.queuedRemovals.forEach((pos, tile) -> printer.add(" - %s : %s", pos, tile == null ? "null" : ((TileEntityBridge)tile).bridge$getPrettyPrinterString()));
                this.queuedRemovals.clear();
            }
            if (!this.affectedTileEntities.isEmpty()) {
                if (pretty == null) {
                    pretty = new PrettyPrinter(60);
                }
                PrettyPrinter prettyPrinter = pretty;
                this.affectedTileEntities.forEach((pos, tileEntity) -> {
                    if (tileEntity == null) {
                        return;
                    }
                    if (!this.hasTile) {
                        printer.add("Unremoved TileEntities affected by the proxy, likely will cause issues if these are meant to be added to the world!");
                    }
                    this.hasTile = true;
                    printer.add(" - %s : %s", pos, ((TileEntityBridge)tileEntity).bridge$getPrettyPrinterString());
                });
                this.affectedTileEntities.clear();
            }
            if (pretty != null && this.hasTile) {
                pretty.add("Following the necessary steps to have removed the above entries, the proxy is now being cleared.");
                this.hasTile = false;
                pretty.trace(System.err);
            }
        }
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.affectedTileEntities.get(pos);
    }

    public boolean hasTileEntity(BlockPos pos) {
        return this.affectedTileEntities.containsKey(pos);
    }

    public boolean hasTileEntity(BlockPos pos, TileEntity tileEntity) {
        return this.affectedTileEntities.get(pos) == tileEntity;
    }

    public boolean isTileEntityRemoved(BlockPos pos) {
        return this.markedRemoved.contains(pos);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.processed.get(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.processingWorld.func_175623_d(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.processingWorld.func_175627_a(pos, direction);
    }

    public void onChunkChanged(BlockPos pos, IBlockState newState) {
        if (this.proxies.isEmpty()) {
            if (!this.processed.isEmpty()) {
                this.processed.clear();
            }
            return;
        }
        if (this.processingTransaction != null) {
            BlockTransaction transaction = this.processingTransaction;
            while (transaction != null) {
                if (transaction.acceptChunkChange(pos, newState)) {
                    IBlockState iBlockState = transaction.blocksNotAffected.put(pos, newState);
                }
                transaction = transaction.next;
            }
        }
        this.proceed(pos, newState, false);
    }

    private void unmarkRemoval(BlockPos pos) {
        Proxy proxy;
        this.markedRemoved.remove(pos);
        if (!this.proxies.isEmpty() && (proxy = this.proxies.peek()).isMarkedForRemoval(pos)) {
            proxy.unmarkRemoval(pos);
        }
    }

    void unmarkRemoval(BlockPos pos, TileEntity tileEntity) {
        this.unmarkRemoval(pos);
        if (tileEntity != null) {
            this.queuedRemovals.remove(pos, tileEntity);
            TileEntity removed = (TileEntity)this.affectedTileEntities.remove(pos);
            if (removed != null) {
                this.affectedTileEntities.put(pos, tileEntity);
            }
        }
    }

    void proceedWithRemoval(BlockPos targetPosition, TileEntity removed) {
        this.markedRemoved.remove(targetPosition);
        TileEntity existing = (TileEntity)this.affectedTileEntities.remove(targetPosition);
        if (removed != null) {
            this.queuedRemovals.remove(targetPosition, removed);
            if (this.queuedTiles.containsEntry(targetPosition, removed)) {
                this.markRemovedTile(targetPosition);
            } else {
                this.removeTileEntityFromWorldAndChunk(removed);
            }
        }
    }

    private void removeTileEntityFromWorldAndChunk(TileEntity removed) {
        ChunkBridge activeChunk;
        if (((WorldAccessor)this.processingWorld).accessor$getProcessingLoadedTiles()) {
            ((WorldAccessor)this.processingWorld).accessor$getAddedTileEntityList().remove(removed);
            if (!(removed instanceof ITickable)) {
                this.processingWorld.field_147482_g.remove(removed);
            }
        } else {
            ((WorldAccessor)this.processingWorld).accessor$getAddedTileEntityList().remove(removed);
            this.processingWorld.field_147482_g.remove(removed);
            this.processingWorld.field_175730_i.remove(removed);
        }
        if ((activeChunk = ((ActiveChunkReferantBridge)removed).bridge$getActiveChunk()) != null) {
            activeChunk.bridge$removeTileEntity(removed);
        }
    }

    void proceedWithAdd(BlockPos targetPos, TileEntity added) {
        boolean removed = this.queuedTiles.remove(targetPos, added);
        if (!removed) {
            System.err.println("Unknown removal for: " + targetPos + " with tile entity: " + added);
        }
        this.unmarkRemoval(targetPos, added);
        TileEntity existing = (TileEntity)this.affectedTileEntities.remove(targetPos);
        if (existing != null && existing != added) {
            ((TileEntityBridge)existing).bridge$setCaptured(false);
            existing.func_145843_s();
        }
        ((TileEntityBridge)added).bridge$setCaptured(false);
        if (((WorldAccessor)this.processingWorld).accessor$getProcessingLoadedTiles()) {
            added.func_174878_a(targetPos);
            if (added.func_145831_w() != this.processingWorld) {
                added.func_145834_a((World)this.processingWorld);
            }
            ((WorldAccessor)this.processingWorld).accessor$getAddedTileEntityList().add(added);
        } else {
            Chunk chunk = this.processingWorld.func_175726_f(targetPos);
            if (!chunk.func_76621_g()) {
                ((ChunkBridge)chunk).bridge$setTileEntity(targetPos, added);
            }
            this.processingWorld.func_175700_a(added);
        }
    }

    public List<TileEntity> getQueuedTiles(BlockPos pos) {
        return this.queuedTiles.get((Object)pos);
    }

    public boolean isTileQueued(BlockPos pos, TileEntity tileEntity) {
        return this.queuedTiles.containsEntry(pos, tileEntity);
    }

    public boolean isTileQueuedForRemoval(BlockPos pos, TileEntity tileEntity) {
        return this.queuedRemovals.containsEntry(pos, tileEntity);
    }

    void queueTileAddition(BlockPos pos, TileEntity added) {
        this.affectedTileEntities.put(pos, added);
        this.markedRemoved.remove(pos);
        if (added != null && added.func_145831_w() != this.processingWorld) {
            added.func_145834_a((World)this.processingWorld);
        }
        this.queuedTiles.put(pos, added);
    }

    void unQueueTileAddition(BlockPos pos, TileEntity added) {
        TileEntity remove = (TileEntity)this.affectedTileEntities.remove(pos);
        if (remove != added) {
            this.affectedTileEntities.put(pos, remove);
        }
        this.queuedTiles.remove(pos, added);
    }

    void queueRemoval(TileEntity removed) {
        if (removed != null) {
            BlockPos pos = removed.func_174877_v();
            this.affectedTileEntities.put(pos, null);
            this.markRemovedTile(pos);
            if (!this.queuedRemovals.containsEntry(pos, removed)) {
                this.queuedRemovals.put(pos, removed);
            }
        }
    }

    void queueReplacement(TileEntity added, TileEntity removed) {
        TileEntity existing = this.affectedTileEntities.put(removed.func_174877_v(), added);
        this.markedRemoved.remove(removed.func_174877_v());
        if (existing != null && existing != removed) {
            this.queuedRemovals.put(existing.func_174877_v(), existing);
        }
        this.queuedTiles.put(added.func_174877_v(), added);
    }

    public boolean succeededInAdding(BlockPos pos, TileEntity tileEntity) {
        TileEntity removed = (TileEntity)this.affectedTileEntities.remove(pos);
        if (removed != null && removed != tileEntity) {
            System.err.println("Removed a tile entity that wasn't expected to be removed: " + removed);
            return false;
        }
        return true;
    }

    void pushTile(BlockPos pos, TileEntity tile) {
        this.affectedTileEntities.put(pos, tile);
        if (tile == null) {
            this.markRemovedTile(pos);
        } else {
            this.unmarkRemoval(pos);
        }
    }

    private void markRemovedTile(BlockPos pos) {
        Proxy proxy;
        boolean added = this.markedRemoved.add(pos);
        if (added) {
            this.affectedTileEntities.put(pos, null);
        }
        if (!this.proxies.isEmpty() && !(proxy = this.proxies.peek()).isMarkedForRemoval(pos)) {
            proxy.storeMarkedRemoval(pos);
        }
    }

    public WorldServerBridge getWorld() {
        return (WorldServerBridge)this.processingWorld;
    }

    public void addToPrinter(PrettyPrinter printer) {
        printer.add(" BlockStates");
        this.processed.forEach((pos, state) -> printer.add("  %s : %s", pos, state));
        printer.add().add(" MarkedRemoved");
        this.markedRemoved.forEach(pos -> printer.add("  - %s", pos));
        printer.add().add(" Affected Tiles");
        this.affectedTileEntities.forEach((pos, tileEntity) -> printer.add("  - %s : %s", pos, tileEntity == null ? "null" : ((TileEntityBridge)tileEntity).bridge$getPrettyPrinterString()));
        printer.add().add(" QueuedTiles");
        this.queuedTiles.forEach((pos, tileEntity) -> printer.add("  - %s : %s", pos, tileEntity == null ? "null" : ((TileEntityBridge)tileEntity).bridge$getPrettyPrinterString()));
        printer.add().add(" QueuedRemovals");
        this.queuedRemovals.forEach((pos, tileEntity) -> printer.add("  - %s: %s", pos, tileEntity == null ? "null" : ((TileEntityBridge)tileEntity).bridge$getPrettyPrinterString()));
    }

    @Override
    public void close() {
        if (this.processingStack == null) {
            this.processingTransaction = null;
            return;
        }
        BlockTransaction peek = this.processingStack.peek();
        if (this.processingTransaction != peek) {
            return;
        }
        this.processingStack.pop();
        if (!this.processingStack.isEmpty()) {
            this.processingTransaction = this.processingStack.peek();
            if (this.processingTransaction instanceof BlockTransaction.NeighborNotification) {
                this.isNeighbor = true;
            }
        }
        this.processingTransaction = null;
        this.isNeighbor = false;
    }

    public SpongeProxyBlockAccess switchTo(BlockTransaction transaction) {
        if (this.processingTransaction != null) {
            if (this.processingStack == null) {
                this.processingStack = new ArrayDeque<BlockTransaction>();
            }
            this.processingStack.push(this.processingTransaction);
            this.processingStack.push(transaction);
        }
        this.processingTransaction = transaction;
        if (transaction instanceof BlockTransaction.NeighborNotification) {
            this.isNeighbor = true;
        }
        return this;
    }

    public boolean isProcessingNeighbors() {
        return this.isNeighbor;
    }

    public boolean hasProxy() {
        return !this.proxies.isEmpty();
    }

    public TileEntity getQueuedTileForRemoval(BlockPos pos) {
        if (this.queuedRemovals.isEmpty()) {
            return null;
        }
        Collection tiles = this.queuedRemovals.get((Object)pos);
        if (tiles.isEmpty()) {
            return null;
        }
        return (TileEntity)tiles.get(0);
    }

    public boolean isProcessingTransactionWithNextHavingBreak(BlockPos pos, IBlockState state) {
        if (this.processingTransaction == null) {
            return false;
        }
        BlockTransaction transaction = this.processingTransaction;
        while (transaction != null) {
            if (transaction.next == null) {
                return false;
            }
            if (transaction.next.affectedPosition.equals((Object)pos) && transaction.next instanceof BlockTransaction.ChangeBlock) {
                BlockTransaction.ChangeBlock change = (BlockTransaction.ChangeBlock)transaction.next;
                if (change.queueBreak && change.original.getState() == state && change.original.blockChange == BlockChange.BREAK) {
                    return true;
                }
            }
            transaction = transaction.next;
        }
        return false;
    }

    public static final class Proxy
    implements AutoCloseable {
        private final SpongeProxyBlockAccess proxyAccess;
        @Nullable
        Exception stack_debug;
        @Nullable
        private LinkedHashMap<BlockPos, IBlockState> processed;
        @Nullable
        private Set<BlockPos> newBlocks;
        @Nullable
        private Set<BlockPos> markedRemovedTiles;
        @Nullable
        private LinkedHashMap<BlockPos, TileEntity> removedTiles;

        Proxy(SpongeProxyBlockAccess spongeProxyBlockAccess) {
            this.proxyAccess = spongeProxyBlockAccess;
        }

        @Override
        public void close() {
            this.proxyAccess.popProxy(this);
        }

        boolean hasNew() {
            return this.newBlocks != null && !this.newBlocks.isEmpty();
        }

        boolean hasStored() {
            return this.processed != null && !this.processed.isEmpty();
        }

        void markNew(BlockPos pos) {
            if (this.newBlocks == null) {
                this.newBlocks = new HashSet<BlockPos>();
            }
            this.newBlocks.add(pos);
        }

        boolean isNew(BlockPos pos) {
            return this.newBlocks != null && this.newBlocks.contains(pos);
        }

        boolean isStored(BlockPos pos) {
            return this.processed != null && this.processed.containsKey(pos);
        }

        void store(BlockPos pos, IBlockState state) {
            if (this.processed == null) {
                this.processed = new LinkedHashMap();
            }
            this.processed.put(pos, state);
        }

        boolean isMarkedForRemoval(BlockPos pos) {
            return this.markedRemovedTiles != null && this.markedRemovedTiles.contains(pos);
        }

        public boolean isStoredRemoval(BlockPos pos) {
            return this.removedTiles != null && this.removedTiles.containsKey(pos);
        }

        void storeMarkedRemoval(BlockPos pos) {
            if (this.markedRemovedTiles == null) {
                this.markedRemovedTiles = new HashSet<BlockPos>();
            }
            this.markedRemovedTiles.add(pos);
        }

        boolean hasRemovals() {
            return this.markedRemovedTiles != null && !this.markedRemovedTiles.isEmpty();
        }

        void unmarkRemoval(BlockPos pos) {
            this.markedRemovedTiles.remove(pos);
        }
    }
}

