/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;

final class BlockDropItemsPhaseState
extends BlockPhaseState {
    private final BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> BLOCK_DROP_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        BlockSnapshot blockSnapshot = ctx.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", ctx));
        frame.pushCause(blockSnapshot);
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
    });

    BlockDropItemsPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> getFrameModifier() {
        return this.BLOCK_DROP_MODIFIER;
    }

    @Override
    public GeneralizedContext createNewContext() {
        return (GeneralizedContext)((GeneralizedContext)super.createNewContext().addBlockCaptures()).addEntityCaptures();
    }

    @Override
    public void unwind(GeneralizedContext context) {
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (EntityItem item : items) {
                entities.add((Entity)item);
            }
            SpongeCommonEventFactory.callDropItemDestruct(entities, context);
        });
        context.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(drops -> drops.asMap().forEach((key, value) -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(new ArrayList<Entity>((Collection<Entity>)value), context);
        }));
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, context));
        SpongeBlockSnapshot blockSnapshot = context.getSource(SpongeBlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", context));
        Optional<WorldServerBridge> maybeWorld = blockSnapshot.getWorldServer().map(worldserver -> (WorldServerBridge)worldserver);
        TrackingUtil.processBlockCaptures(context);
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> maybeWorld.ifPresent(mixinWorld -> {
            List<Entity> items = drops.stream().map(drop -> drop.create((WorldServer)mixinWorld)).collect(Collectors.toList());
            List<Entity> entities = items;
            if (!entities.isEmpty()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                SpongeCommonEventFactory.callDropItemCustom(entities, context);
            }
            drops.clear();
        }));
        context.getBlockDropSupplier().acceptAndClearIfNotEmpty(drops -> {
            for (BlockPos key : drops.asMap().keySet()) {
                Collection values = drops.get(key);
                if (values.isEmpty()) continue;
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                TrackingUtil.spawnItemDataForBlockDrops(values, blockSnapshot, context);
            }
        });
    }

    @Override
    public boolean tracksBlockSpecificDrops(GeneralizedContext context) {
        return true;
    }
}

