/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import com.google.common.base.Preconditions;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public class GrowablePhaseContext
extends PhaseContext<GrowablePhaseContext> {
    protected PhaseContext<?> priorContext;
    ItemStackSnapshot usedItem;
    World world;
    IBlockState blockState;
    BlockPos pos;
    SpongeBlockSnapshot snapshot;

    protected GrowablePhaseContext(IPhaseState<? extends GrowablePhaseContext> state) {
        super(state);
    }

    public GrowablePhaseContext provideItem(ItemStack stack) {
        this.usedItem = ItemStackUtil.snapshotOf(stack);
        this.priorContext = PhaseTracker.getInstance().getCurrentContext();
        return this;
    }

    public GrowablePhaseContext world(World worldIn) {
        this.world = worldIn;
        return this;
    }

    public GrowablePhaseContext block(IBlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    public GrowablePhaseContext pos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public GrowablePhaseContext buildAndSwitch() {
        Preconditions.checkState(this.pos != null, "BlockPos is null");
        Preconditions.checkState(this.blockState != null, "BlockState is null");
        Preconditions.checkState(this.usedItem != null, "ItemUsed is null");
        Preconditions.checkState(this.priorContext != null, "Prior context is null");
        Preconditions.checkState(this.world != null, "World is null");
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().worldId(((org.spongepowered.api.world.World)this.world).getUniqueId()).position(VecHelper.toVector3i(this.pos)).blockState(this.blockState).flag(BlockChangeFlags.PHYSICS_OBSERVER);
        this.priorContext.applyOwnerIfAvailable(owner -> builder.creator(owner.getUniqueId()));
        this.priorContext.applyNotifierIfAvailable(notifier -> builder.notifier(notifier.getUniqueId()));
        this.snapshot = builder.build();
        return (GrowablePhaseContext)super.buildAndSwitch();
    }

    @Override
    protected void reset() {
        super.reset();
        this.priorContext = null;
        this.usedItem = null;
        this.world = null;
        this.blockState = null;
        this.pos = null;
        this.snapshot = null;
    }
}

