/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class ExplosionState
extends GeneralState<ExplosionContext> {
    private final BiConsumer<CauseStackManager.StackFrame, ExplosionContext> EXPLOSION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> frame.pushCause(context.getExplosion()));

    ExplosionState() {
    }

    @Override
    public ExplosionContext createNewContext() {
        return ((ExplosionContext)((ExplosionContext)((ExplosionContext)new ExplosionContext().addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures()).populateFromCurrentState();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ExplosionContext> getFrameModifier() {
        return this.EXPLOSION_MODIFIER;
    }

    @Override
    public boolean tracksBlockSpecificDrops(ExplosionContext context) {
        return true;
    }

    @Override
    public boolean requiresBlockPosTracking() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public void unwind(ExplosionContext context) {
        TrackingUtil.processBlockCaptures(context);
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            try (CauseStackManager.StackFrame smaller = Sponge.getCauseStackManager().pushCauseFrame();){
                smaller.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.TNT_IGNITE);
                SpongeCommonEventFactory.callSpawnEntity(entities, context);
            }
        });
        context.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(drops -> drops.asMap().forEach((pos, items) -> {
            if (ShouldFire.DROP_ITEM_EVENT_DESTRUCT) {
                List itemEntities = items.stream().map(entity -> (org.spongepowered.api.entity.Entity)entity).collect(Collectors.toList());
                DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemEntities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    EntityUtil.processEntitySpawnsFromEvent(context, event);
                }
            } else {
                items.forEach(item -> EntityUtil.processEntitySpawn((org.spongepowered.api.entity.Entity)item, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context)));
            }
        }));
    }

    @Override
    public ChangeBlockEvent.Post createChangeBlockPostEvent(ExplosionContext context, ImmutableList<Transaction<BlockSnapshot>> transactions, Cause cause) {
        return SpongeEventFactory.createExplosionEventPost(cause, context.getSpongeExplosion(), transactions);
    }

    @Override
    public boolean spawnEntityOrCapture(ExplosionContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        return context.getBlockPosition().map(blockPos -> {
            Object blockPosEntityMultimap = context.getPerBlockEntitySpawnSuppplier().get();
            Object blockPosEntityItemMultimap = context.getBlockItemDropSupplier().get();
            if (entity instanceof EntityItem) {
                blockPosEntityItemMultimap.put(blockPos, (EntityItem)entity);
            } else {
                blockPosEntityMultimap.put(blockPos, (Entity)entity);
            }
            return true;
        }).orElseGet(() -> {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                Boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl2;
            }
        });
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

