/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketSpectate;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryAddSlotState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStartState;
import org.spongepowered.common.event.tracking.phase.packet.drag.MiddleDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.PrimaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.SecondaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CloseWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CreativeInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DoubleClickInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemOutsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.EnchantItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.MiddleInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.OpenInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PlaceRecipePacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryShiftClick;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryShiftClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwapHandItemsState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarNumberPressState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarScrollState;
import org.spongepowered.common.event.tracking.phase.packet.player.AnimationPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.AttackEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.IgnoredPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractAtEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InvalidPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.MovementPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlaceBlockPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.ResourcePackState;
import org.spongepowered.common.event.tracking.phase.packet.player.StopSleepingPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UnknownPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UpdateSignState;
import org.spongepowered.common.event.tracking.phase.packet.player.UseItemPacketState;
import org.spongepowered.common.util.Constants;

public final class PacketPhase {
    private final Map<Class<? extends Packet<?>>, Function<Packet<?>, IPhaseState<? extends PacketContext<?>>>> packetTranslationMap = new IdentityHashMap();
    private static final ImmutableMap<CPacketEntityAction.Action, IPhaseState<? extends PacketContext<?>>> PLAYER_ACTION_MAPPINGS = ImmutableMap.builder().put(CPacketEntityAction.Action.START_SNEAKING, General.START_SNEAKING).put(CPacketEntityAction.Action.STOP_SNEAKING, General.STOP_SNEAKING).put(CPacketEntityAction.Action.STOP_SLEEPING, General.STOP_SLEEPING).put(CPacketEntityAction.Action.START_SPRINTING, General.START_SPRINTING).put(CPacketEntityAction.Action.STOP_SPRINTING, General.STOP_SPRINTING).put(CPacketEntityAction.Action.START_RIDING_JUMP, General.START_RIDING_JUMP).put(CPacketEntityAction.Action.STOP_RIDING_JUMP, General.STOP_RIDING_JUMP).put(CPacketEntityAction.Action.OPEN_INVENTORY, Inventory.OPEN_INVENTORY).put(CPacketEntityAction.Action.START_FALL_FLYING, General.START_FALL_FLYING).build();
    private static final ImmutableMap<CPacketPlayerDigging.Action, IPhaseState<? extends PacketContext<?>>> INTERACTION_ACTION_MAPPINGS = ImmutableMap.builder().put(CPacketPlayerDigging.Action.DROP_ITEM, Inventory.DROP_ITEM_WITH_HOTKEY).put(CPacketPlayerDigging.Action.DROP_ALL_ITEMS, Inventory.DROP_ITEM_WITH_HOTKEY).put(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, (BasicInventoryPacketState)General.INTERACTION).put(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, General.INTERACTION).put(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, General.INTERACTION).put(CPacketPlayerDigging.Action.RELEASE_USE_ITEM, General.INTERACTION).put(CPacketPlayerDigging.Action.SWAP_HELD_ITEMS, Inventory.SWAP_HAND_ITEMS).build();

    boolean isPacketInvalid(Packet<?> packetIn, EntityPlayerMP packetPlayer, IPhaseState<? extends PacketContext<?>> packetState) {
        return ((PacketState)packetState).isPacketIgnored(packetIn, packetPlayer);
    }

    IPhaseState<? extends PacketContext<?>> getStateForPacket(Packet<?> packet) {
        Function<Packet<?>, IPhaseState<PacketContext<?>>> packetStateFunction = this.packetTranslationMap.get(packet.getClass());
        if (packetStateFunction != null) {
            return packetStateFunction.apply(packet);
        }
        return General.UNKNOWN;
    }

    public PhaseContext<?> populateContext(Packet<?> packet, EntityPlayerMP entityPlayerMP, IPhaseState<?> state, PhaseContext<?> context) {
        Preconditions.checkNotNull(packet, "Packet cannot be null!");
        Preconditions.checkArgument(!context.isComplete(), "PhaseContext cannot be marked as completed!");
        ((PacketState)state).populateContext(entityPlayerMP, packet, (PacketContext)context);
        return context;
    }

    private static BasicInventoryPacketState fromWindowPacket(CPacketClickWindow windowPacket) {
        int mode = 512 << windowPacket.func_186993_f().ordinal();
        int packed = windowPacket.func_149543_e();
        int unpacked = mode == Constants.Networking.MODE_DRAG ? 64 << (packed >> 2 & 3) | 8 << (packed & 3) : 1 << (packed & 3);
        BasicInventoryPacketState inventory = PacketPhase.fromState(PacketPhase.clickType(windowPacket.func_149544_d()) | mode | unpacked);
        if (inventory == Inventory.INVENTORY) {
            SpongeImpl.getLogger().warn(String.format("Unable to find InventoryPacketState handler for click window packet: %s", windowPacket));
        }
        return inventory;
    }

    private static int clickType(int slotId) {
        return slotId == -999 || slotId == -1 ? 131072 : 65536;
    }

    private static BasicInventoryPacketState fromState(int state) {
        for (BasicInventoryPacketState inventory : Inventory.VALUES) {
            if (!inventory.matches(state)) continue;
            return inventory;
        }
        return Inventory.INVENTORY;
    }

    public static PacketPhase getInstance() {
        return Holder.INSTANCE;
    }

    PacketPhase() {
        this.setupPacketToStateMapping();
    }

    private void setupPacketToStateMapping() {
        this.packetTranslationMap.put(CPacketKeepAlive.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketChatMessage.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketUseEntity.class, packet -> {
            CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
            CPacketUseEntity.Action action = useEntityPacket.func_149565_c();
            if (action == CPacketUseEntity.Action.INTERACT) {
                return General.INTERACT_ENTITY;
            }
            if (action == CPacketUseEntity.Action.ATTACK) {
                return General.ATTACK_ENTITY;
            }
            if (action == CPacketUseEntity.Action.INTERACT_AT) {
                return General.INTERACT_AT_ENTITY;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPacketPlayer.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.Position.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.Rotation.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.PositionRotation.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayerDigging.class, packet -> {
            CPacketPlayerDigging playerDigging = (CPacketPlayerDigging)packet;
            CPacketPlayerDigging.Action action = playerDigging.func_180762_c();
            IPhaseState<? extends PacketContext<?>> state = INTERACTION_ACTION_MAPPINGS.get(action);
            return state == null ? General.UNKNOWN : state;
        });
        this.packetTranslationMap.put(CPacketPlayerTryUseItemOnBlock.class, packet -> {
            CPacketPlayerTryUseItemOnBlock blockPlace = (CPacketPlayerTryUseItemOnBlock)packet;
            BlockPos blockPos = blockPlace.func_187023_a();
            EnumFacing front = blockPlace.func_187024_b();
            MinecraftServer server = SpongeImpl.getServer();
            if (blockPos.func_177956_o() < server.func_71207_Z() - 1 || front != EnumFacing.UP && blockPos.func_177956_o() < server.func_71207_Z()) {
                return General.PLACE_BLOCK;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPacketPlayerTryUseItem.class, packet -> General.USE_ITEM);
        this.packetTranslationMap.put(CPacketHeldItemChange.class, packet -> Inventory.SWITCH_HOTBAR_SCROLL);
        this.packetTranslationMap.put(CPacketAnimation.class, packet -> General.ANIMATION);
        this.packetTranslationMap.put(CPacketEntityAction.class, packet -> {
            CPacketEntityAction playerAction = (CPacketEntityAction)packet;
            CPacketEntityAction.Action action = playerAction.func_180764_b();
            return PLAYER_ACTION_MAPPINGS.get(action);
        });
        this.packetTranslationMap.put(CPacketInput.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketCloseWindow.class, packet -> General.CLOSE_WINDOW);
        this.packetTranslationMap.put(CPacketClickWindow.class, packet -> PacketPhase.fromWindowPacket((CPacketClickWindow)packet));
        this.packetTranslationMap.put(CPacketConfirmTransaction.class, packet -> General.UNKNOWN);
        this.packetTranslationMap.put(CPacketCreativeInventoryAction.class, packet -> General.CREATIVE_INVENTORY);
        this.packetTranslationMap.put(CPacketEnchantItem.class, packet -> Inventory.ENCHANT_ITEM);
        this.packetTranslationMap.put(CPacketUpdateSign.class, packet -> General.UPDATE_SIGN);
        this.packetTranslationMap.put(CPacketPlayerAbilities.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketTabComplete.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketClientStatus.class, packet -> {
            CPacketClientStatus clientStatus = (CPacketClientStatus)packet;
            CPacketClientStatus.State status = clientStatus.func_149435_c();
            if (status == CPacketClientStatus.State.PERFORM_RESPAWN) {
                return General.REQUEST_RESPAWN;
            }
            return General.IGNORED;
        });
        this.packetTranslationMap.put(CPacketCustomPayload.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketSpectate.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketResourcePackStatus.class, packet -> General.RESOURCE_PACK);
        this.packetTranslationMap.put(CPacketPlaceRecipe.class, packet -> Inventory.PLACE_RECIPE);
    }

    private static final class Holder {
        static final PacketPhase INSTANCE = new PacketPhase();

        private Holder() {
        }
    }

    public static final class Inventory {
        static final BasicInventoryPacketState INVENTORY = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_CLICK = new PrimaryInventoryClickState();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_CLICK = new SecondaryInventoryClickState();
        public static final BasicInventoryPacketState MIDDLE_INVENTORY_CLICK = new MiddleInventoryClickState();
        public static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW = new DropItemOutsideWindowState(Constants.Networking.MODE_CLICK | 1 | 2 | 0x20000);
        public static final BasicInventoryPacketState DROP_ITEM_WITH_HOTKEY = new DropItemWithHotkeyState();
        public static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW_NOOP = new DropItemOutsideWindowState(Constants.Networking.MODE_DROP | 1 | 2 | 0x20000);
        public static final BasicInventoryPacketState DROP_ITEMS = new BasicInventoryPacketState();
        static final BasicInventoryPacketState DROP_INVENTORY = new DropInventoryState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_NUMBER_PRESS = new SwitchHotbarNumberPressState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_SHIFT_CLICK = new PrimaryInventoryShiftClick();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_SHIFT_CLICK = new SecondaryInventoryShiftClickState();
        static final BasicInventoryPacketState DOUBLE_CLICK_INVENTORY = new DoubleClickInventoryState();
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_START = new DragInventoryStartState("PRIMARY_DRAG_INVENTORY_START", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_START = new DragInventoryStartState("SECONDARY_DRAG_INVENTORY_START", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_START = new DragInventoryStartState("MIDDLE_DRAG_INVENTORY_START", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("PRIMARY_DRAG_INVENTORY_ADD_SLOT", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("SECONDARY_DRAG_INVENTORY_ADD_SLOT", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("MIDDLE_DRAG_INVENTORY_ADD_SLOT", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_STOP = new PrimaryDragInventoryStopState();
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_STOP = new SecondaryDragInventoryStopState();
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_STOP = new MiddleDragInventoryStopState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_SCROLL = new SwitchHotbarScrollState();
        public static final BasicInventoryPacketState OPEN_INVENTORY = new OpenInventoryState();
        static final BasicInventoryPacketState ENCHANT_ITEM = new EnchantItemPacketState();
        public static final BasicInventoryPacketState SWAP_HAND_ITEMS = new SwapHandItemsState();
        public static final BasicInventoryPacketState PLACE_RECIPE = new PlaceRecipePacketState();
        static final ImmutableList<BasicInventoryPacketState> VALUES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(INVENTORY)).add(PRIMARY_INVENTORY_CLICK)).add(SECONDARY_INVENTORY_CLICK)).add(MIDDLE_INVENTORY_CLICK)).add(DROP_ITEM_OUTSIDE_WINDOW)).add(DROP_ITEM_WITH_HOTKEY)).add(DROP_ITEM_OUTSIDE_WINDOW_NOOP)).add(DROP_ITEMS)).add(DROP_INVENTORY)).add(SWITCH_HOTBAR_NUMBER_PRESS)).add(PRIMARY_INVENTORY_SHIFT_CLICK)).add(SECONDARY_INVENTORY_SHIFT_CLICK)).add(DOUBLE_CLICK_INVENTORY)).add(PRIMARY_DRAG_INVENTORY_START)).add(SECONDARY_DRAG_INVENTORY_START)).add(MIDDLE_DRAG_INVENTORY_START)).add(PRIMARY_DRAG_INVENTORY_ADDSLOT)).add(SECONDARY_DRAG_INVENTORY_ADDSLOT)).add(MIDDLE_DRAG_INVENTORY_ADDSLOT)).add(PRIMARY_DRAG_INVENTORY_STOP)).add(SECONDARY_DRAG_INVENTORY_STOP)).add(MIDDLE_DRAG_INVENTORY_STOP)).add(SWITCH_HOTBAR_SCROLL)).add(OPEN_INVENTORY)).add(ENCHANT_ITEM)).build();
    }

    public static final class General {
        public static final IPhaseState<BasicPacketContext> UNKNOWN = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> MOVEMENT = new MovementPacketState();
        static final IPhaseState<InteractionPacketContext> INTERACTION = new InteractionPacketState();
        static final IPhaseState<BasicPacketContext> IGNORED = new IgnoredPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_ENTITY = new InteractEntityPacketState();
        static final IPhaseState<BasicPacketContext> ATTACK_ENTITY = new AttackEntityPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_AT_ENTITY = new InteractAtEntityPacketState();
        static final IPhaseState<BasicPacketContext> CREATIVE_INVENTORY = new CreativeInventoryPacketState();
        static final IPhaseState<BasicPacketContext> PLACE_BLOCK = new PlaceBlockPacketState();
        static final IPhaseState<BasicPacketContext> REQUEST_RESPAWN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> USE_ITEM = new UseItemPacketState();
        static final IPhaseState<BasicPacketContext> INVALID = new InvalidPacketState();
        static final IPhaseState<BasicPacketContext> START_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> ANIMATION = new AnimationPacketState();
        static final IPhaseState<BasicPacketContext> START_SNEAKING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SNEAKING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> START_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SLEEPING = new StopSleepingPacketState();
        public static final IPhaseState<BasicPacketContext> CLOSE_WINDOW = new CloseWindowState();
        static final IPhaseState<BasicPacketContext> UPDATE_SIGN = new UpdateSignState();
        static final IPhaseState<BasicPacketContext> RESOURCE_PACK = new ResourcePackState();
        static final IPhaseState<BasicPacketContext> STOP_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> HANDLED_EXTERNALLY = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> START_FALL_FLYING = new BasicPacketState();
    }
}

