/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class PlaceRecipePacketState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        ((TrackedInventoryBridge)playerMP.field_71070_bA).bridge$setCaptureInventory(true);
        ((ContainerBridge)playerMP.field_71070_bA).bridge$setFirePreview(false);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        CPacketPlaceRecipe packet = (CPacketPlaceRecipe)context.getPacket();
        boolean shift = packet.func_194319_c();
        IRecipe recipe = packet.func_194317_b();
        EntityPlayerMP player = context.getPacketPlayer();
        ((ContainerBridge)player.field_71070_bA).bridge$detectAndSendChanges(true);
        ((TrackedInventoryBridge)player.field_71070_bA).bridge$setCaptureInventory(false);
        ((ContainerBridge)player.field_71070_bA).bridge$setFirePreview(true);
        Object craftInv = ((Inventory)player.field_71070_bA).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeImpl.getLogger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        SlotTransaction previewTransaction = ((ContainerBridge)player.field_71070_bA).bridge$getPreviewTransaction();
        if (previewTransaction == null) {
            CraftingOutput slot = ((CraftingInventory)craftInv).getResult();
            previewTransaction = new SlotTransaction(slot, ItemStackSnapshot.NONE, ItemStackUtil.snapshotOf(slot.peek().orElse(ItemStack.empty())));
        }
        SpongeCommonEventFactory.callCraftEventPre((EntityPlayer)player, (CraftingInventory)craftInv, previewTransaction, (CraftingRecipe)recipe, player.field_71070_bA, ImmutableList.of(previewTransaction));
        ((ContainerBridge)player.field_71070_bA).bridge$setPreviewTransaction(null);
        Entity spongePlayer = (Entity)player;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.pushCause(player.field_71070_bA);
            List<SlotTransaction> transactions = ((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions();
            ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(cursor, cursor);
            ClickInventoryEvent.Recipe event = shift ? SpongeEventFactory.createClickInventoryEventRecipeAll(frame.getCurrentCause(), cursorTransaction, (Recipe)recipe, Optional.empty(), (Container)player.field_71070_bA, transactions) : SpongeEventFactory.createClickInventoryEventRecipeSingle(frame.getCurrentCause(), cursorTransaction, (Recipe)recipe, Optional.empty(), (Container)player.field_71070_bA, transactions);
            SpongeImpl.postEvent(event);
            if (event.isCancelled() || !event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getOriginal());
            } else {
                PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getFinal());
            }
            PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, player.field_71070_bA, event.getTransactions(), event.isCancelled());
            event.getTransactions().clear();
        }
    }
}

