/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class SwitchHotbarScrollState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
        context.setOldHighlightedSlot(playerMP.field_71071_by.field_70461_c);
    }

    @Override
    public ClickInventoryEvent createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return SpongeEventFactory.createClickInventoryEventNumberPress(Sponge.getCauseStackManager().getCurrentCause(), transaction, Optional.ofNullable(slot), openContainer, slotTransactions, usedButton);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        CPacketHeldItemChange itemChange = (CPacketHeldItemChange)context.getPacket();
        int previousSlot = context.getOldHighlightedSlotId();
        net.minecraft.inventory.Container inventoryContainer = player.field_71069_bz;
        InventoryPlayer inventory = player.field_71071_by;
        int preHotbarSize = inventory.field_70462_a.size() - InventoryPlayer.func_70451_h() + inventory.field_70460_b.size() + 4 + 1;
        net.minecraft.inventory.Slot sourceSlot = inventoryContainer.func_75139_a(previousSlot + preHotbarSize);
        net.minecraft.inventory.Slot targetSlot = inventoryContainer.func_75139_a(itemChange.func_149614_c() + preHotbarSize);
        ItemStackSnapshot sourceSnapshot = ItemStackUtil.snapshotOf(sourceSlot.func_75211_c());
        ItemStackSnapshot targetSnapshot = ItemStackUtil.snapshotOf(targetSlot.func_75211_c());
        Slot slotPrev = ContainerUtil.getSlot(inventoryContainer, previousSlot + preHotbarSize);
        SlotTransaction sourceTransaction = new SlotTransaction(slotPrev, sourceSnapshot, sourceSnapshot);
        Slot slotNew = ContainerUtil.getSlot(inventoryContainer, itemChange.func_149614_c() + preHotbarSize);
        SlotTransaction targetTransaction = new SlotTransaction(slotNew, targetSnapshot, targetSnapshot);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            ImmutableCollection transactions = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(sourceTransaction)).add(targetTransaction)).build();
            ChangeInventoryEvent.Held changeInventoryEventHeld = SpongeEventFactory.createChangeInventoryEventHeld(frame.getCurrentCause(), slotNew, slotPrev, (Inventory)inventoryContainer, (List)((Object)transactions));
            net.minecraft.inventory.Container openContainer = player.field_71070_bA;
            SpongeImpl.postEvent(changeInventoryEventHeld);
            if (changeInventoryEventHeld.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(changeInventoryEventHeld.getTransactions())) {
                player.field_71135_a.func_147359_a((Packet)new SPacketHeldItemChange(previousSlot));
                inventory.field_70461_c = previousSlot;
            } else {
                PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, changeInventoryEventHeld.getTransactions(), false);
                inventory.field_70461_c = itemChange.func_149614_c();
                player.func_143004_u();
            }
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(false);
        }
    }
}

