/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUseEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class InteractAtEntityPacketState
extends BasicPacketState {
    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packetIn;
        Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184586_b(useEntityPacket.func_186994_b()));
        if (stack != null) {
            context.itemUsed(stack);
        }
        HandType handType = (HandType)useEntityPacket.func_186994_b();
        context.handUsed(handType);
    }

    @Override
    public boolean doesCaptureEntityDrops(BasicPacketContext context) {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)context.getPacket();
        Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = (World)player.field_70170_p;
        if (entity instanceof OwnershipTrackedBridge) {
            ((OwnershipTrackedBridge)entity).tracked$setOwnerReference((User)player);
        } else {
            ((org.spongepowered.api.entity.Entity)entity).setNotifier(player.func_110124_au());
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, context));
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                List<org.spongepowered.api.entity.Entity> items = entities.stream().map(entity1 -> (org.spongepowered.api.entity.Entity)entity1).collect(Collectors.toList());
                SpongeCommonEventFactory.callSpawnEntity(items, context);
            });
            context.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interact At Entity").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
            context.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty(map -> {
                for (Map.Entry entry : map.asMap().entrySet()) {
                    List entities;
                    UUID entityUuid = (UUID)entry.getKey();
                    Entity entityFromUuid = player.func_71121_q().func_175733_a(entityUuid);
                    if (entityFromUuid == null || (entities = entry.getValue().stream().map(entity1 -> (org.spongepowered.api.entity.Entity)entity1).collect(Collectors.toList())).isEmpty()) continue;
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (event.isCancelled()) continue;
                    InteractAtEntityPacketState.processSpawnedEntities(player, event);
                }
            });
            context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
                List items = drops.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                List entities = items.stream().map(entity1 -> (org.spongepowered.api.entity.Entity)entity1).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        InteractAtEntityPacketState.processSpawnedEntities(player, event);
                    }
                }
            });
        }
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

