/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.BlockEventDataBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState<BlockEventTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> FRAME_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        BlockEventDataBridge blockEventData = context.getSource(BlockEventDataBridge.class).orElse(null);
        if (blockEventData != null) {
            if (blockEventData.bridge$getTileEntity() != null) {
                frame.pushCause(blockEventData.bridge$getTileEntity());
            } else if (blockEventData.bridge$getTickingLocatable() != null) {
                frame.pushCause(blockEventData.bridge$getTickingLocatable());
                frame.addContext(EventContextKeys.BLOCK_EVENT_PROCESS, blockEventData.bridge$getTickingLocatable());
            }
        }
    });

    BlockEventTickPhaseState() {
    }

    @Override
    public BlockEventTickContext createNewContext() {
        return (BlockEventTickContext)((BlockEventTickContext)new BlockEventTickContext().addBlockCaptures()).addEntityCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(BlockEventTickContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        context.applyNotifierIfAvailable(user -> {
            ChunkBridge mixinChunk = (ChunkBridge)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (User)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public boolean spawnEntityOrCapture(BlockEventTickContext context, Entity entity, int chunkX, int chunkZ) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            ArrayList<Entity> entities = new ArrayList<Entity>(1);
            entities.add(entity);
            boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl2;
        }
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, BlockEventTickContext context) {
        Block block = (Block)snapshotTransaction.getOriginal().getState().getType();
        SpongeBlockSnapshot original = (SpongeBlockSnapshot)snapshotTransaction.getOriginal();
        BlockPos changedBlockPos = original.getBlockPos();
        original.getWorldServer().ifPresent(worldServer -> {
            ChunkBridge changedMixinChunk = (ChunkBridge)worldServer.func_175726_f(changedBlockPos);
            changedMixinChunk.bridge$getBlockOwner(changedBlockPos).ifPresent(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)owner, PlayerTracker.Type.OWNER));
            changedMixinChunk.bridge$getBlockNotifier(changedBlockPos).ifPresent(user -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)user, PlayerTracker.Type.NOTIFIER));
        });
    }

    @Override
    public void unwind(BlockEventTickContext context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            TrackingUtil.processBlockCaptures(context);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
                for (EntityItem entity : items) {
                    capturedEntities.add((Entity)entity);
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
            });
        }
    }

    @Override
    public boolean getShouldCancelAllTransactions(BlockEventTickContext context, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, boolean noCancelledTransactions) {
        if (!(context.getSource() instanceof TileEntity)) {
            LocatableBlock source = (LocatableBlock)context.getSource();
            if (SpongeImplHooks.hasBlockTileEntity(((IBlockState)source.getBlockState()).func_177230_c(), (IBlockState)source.getBlockState())) {
                context.setWasNotCancelled(noCancelledTransactions);
                return !noCancelledTransactions;
            }
            context.setWasNotCancelled(noCancelledTransactions);
            return !noCancelledTransactions;
        }
        if (!postEvent.getTransactions().isEmpty()) {
            return postEvent.getTransactions().stream().anyMatch(transaction -> {
                BlockState state = ((BlockSnapshot)transaction.getOriginal()).getState();
                BlockType type = state.getType();
                boolean hasTile = SpongeImplHooks.hasBlockTileEntity((Block)type, (IBlockState)state);
                if (!hasTile && !transaction.getIntermediary().isEmpty()) {
                    return transaction.getIntermediary().stream().anyMatch(inter -> {
                        BlockState iterState = inter.getState();
                        BlockType interType = state.getType();
                        boolean interMediaryHasTile = SpongeImplHooks.hasBlockTileEntity((Block)interType, (IBlockState)iterState);
                        context.setWasNotCancelled(!interMediaryHasTile);
                        return interMediaryHasTile;
                    });
                }
                context.setWasNotCancelled(!hasTile);
                return hasTile;
            });
        }
        context.setWasNotCancelled(noCancelledTransactions);
        return !noCancelledTransactions;
    }

    @Override
    public boolean tracksTileEntityChanges(BlockEventTickContext currentContext) {
        return true;
    }

    @Override
    public boolean hasSpecificBlockProcess(BlockEventTickContext context) {
        return true;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(BlockEventTickContext context) {
        return true;
    }
}

