/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class BlockTickPhaseState
extends LocationBasedTickPhaseState<BlockTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BlockTickContext> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        frame.pushCause(this.getLocatableBlockSourceFromContext((PhaseContext<?>)context));
        context.tickingBlock.bridge$getTickFrameModifier().accept((CauseStackManager.StackFrame)frame, (WorldServerBridge)((Object)context.world));
    });
    private final String desc;

    BlockTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BlockTickContext> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public BlockTickContext createNewContext() {
        return (BlockTickContext)new BlockTickContext(this).addCaptures();
    }

    @Override
    public boolean tracksTileEntityChanges(BlockTickContext currentContext) {
        return false;
    }

    @Override
    public boolean shouldProvideModifiers(BlockTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public boolean getShouldCancelAllTransactions(BlockTickContext context, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, boolean noCancelledTransactions) {
        if (!postEvent.getTransactions().isEmpty()) {
            return postEvent.getTransactions().stream().anyMatch(transaction -> {
                BlockPos blockPos;
                BlockState state = ((BlockSnapshot)transaction.getOriginal()).getState();
                BlockType type = state.getType();
                boolean hasTile = SpongeImplHooks.hasBlockTileEntity((Block)type, (IBlockState)state);
                BlockPos pos = VecHelper.toBlockPos(context.getSource(LocatableBlock.class).get().getPosition());
                if (pos.equals((Object)(blockPos = ((SpongeBlockSnapshot)transaction.getOriginal()).getBlockPos())) && !transaction.isValid()) {
                    return true;
                }
                if (!hasTile && !transaction.getIntermediary().isEmpty()) {
                    return transaction.getIntermediary().stream().anyMatch(inter -> {
                        BlockState iterState = inter.getState();
                        BlockType interType = state.getType();
                        return SpongeImplHooks.hasBlockTileEntity((Block)interType, (IBlockState)iterState);
                    });
                }
                return hasTile;
            });
        }
        return false;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(BlockTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public boolean hasSpecificBlockProcess(BlockTickContext context) {
        return true;
    }

    @Override
    public void unwind(BlockTickContext context) {
        TrackingUtil.processBlockCaptures(context);
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
            for (EntityItem entity : items) {
                capturedEntities.add((Entity)entity);
            }
            SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
        });
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, BlockTickContext context) {
        context.applyOwnerIfAvailable(explosionContext::owner);
        context.applyNotifierIfAvailable(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public boolean spawnEntityOrCapture(BlockTickContext context, Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(locatableBlock);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                ArrayList<Entity> entities = new ArrayList<Entity>(1);
                entities.add(entity);
                boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl2;
            }
            ArrayList<Entity> nonExpEntities = new ArrayList<Entity>(1);
            nonExpEntities.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            boolean bl3 = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl3;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean doesBulkBlockCapture(BlockTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(BlockTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public boolean doesCaptureEntityDrops(BlockTickContext context) {
        return true;
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(BlockTickContext phaseContext, IBlockState newState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        if (phaseContext.tickingBlock instanceof IGrowable) {
            if (newBlock == Blocks.field_150350_a) {
                return BlockChange.BREAK;
            }
            if (newBlock instanceof IGrowable || newState.func_185904_a().func_76217_h()) {
                return BlockChange.GROW;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, newBlock, currentState, snapshot, originalBlock);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

