/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.DimensionContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

class DimensionTickPhaseState
extends TickPhaseState<DimensionContext> {
    DimensionTickPhaseState() {
    }

    @Override
    public DimensionContext createNewContext() {
        return (DimensionContext)((DimensionContext)((DimensionContext)new DimensionContext().addBlockCaptures()).addEntityCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(DimensionContext phaseContext) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            TrackingUtil.processBlockCaptures(phaseContext);
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, phaseContext));
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add((Entity)entity);
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, phaseContext);
            });
        }
    }

    @Override
    public boolean spawnEntityOrCapture(DimensionContext context, Entity entity, int chunkX, int chunkZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            boolean bl2 = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl2;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public boolean doesDenyChunkRequests() {
        return false;
    }
}

